/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import [Ljava.lang.Object;;
import bsh.BSHArguments;
import bsh.BSHBlock;
import bsh.BSHMethodInvocation;
import bsh.BSHPrimaryExpression;
import bsh.BSHType;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.ClassGeneratorImpl;
import bsh.DelayedEvalBshMethod;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.Modifiers;
import bsh.Name;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.TargetError;
import bsh.This;
import bsh.Types;
import bsh.UtilEvalError;
import bsh.Variable;
import bsh.org.objectweb.asm.ClassWriter;
import bsh.org.objectweb.asm.CodeVisitor;
import bsh.org.objectweb.asm.Constants;
import bsh.org.objectweb.asm.Label;
import bsh.org.objectweb.asm.Type;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ClassGeneratorUtil
implements Constants {
    String className;
    String fqClassName;
    Class superClass;
    String superClassName;
    Class[] interfaces;
    Variable[] vars;
    Constructor[] superConstructors;
    DelayedEvalBshMethod[] constructors;
    DelayedEvalBshMethod[] methods;
    Modifiers classModifiers;
    boolean isInterface;

    public ClassGeneratorUtil(Modifiers modifiers, String string, String string2, Class clazz, Class[] classArray, Variable[] variableArray, DelayedEvalBshMethod[] delayedEvalBshMethodArray, boolean bl) {
        this.classModifiers = modifiers;
        this.className = string;
        this.fqClassName = string2 != null ? string2.replace('.', '/') + "/" + string : string;
        if (clazz == null) {
            clazz = Object.class;
        }
        this.superClass = clazz;
        this.superClassName = Type.getInternalName(clazz);
        if (classArray == null) {
            classArray = new Class[]{};
        }
        this.interfaces = classArray;
        this.vars = variableArray;
        this.superConstructors = clazz.getDeclaredConstructors();
        this.isInterface = bl;
        this.splitMethodsAndConstructors(string, delayedEvalBshMethodArray);
    }

    public void initStaticNameSpace(NameSpace nameSpace, BSHBlock bSHBlock) {
        try {
            nameSpace.setLocalVariable("_bshConstructors", this.constructors, false);
            nameSpace.setLocalVariable("_bshInstanceInitializer", bSHBlock, false);
        }
        catch (UtilEvalError utilEvalError) {
            throw new InterpreterError("Unable to init class static block: " + utilEvalError);
        }
    }

    private void splitMethodsAndConstructors(String string, DelayedEvalBshMethod[] delayedEvalBshMethodArray) {
        ArrayList<DelayedEvalBshMethod> arrayList = new ArrayList<DelayedEvalBshMethod>();
        ArrayList<DelayedEvalBshMethod> arrayList2 = new ArrayList<DelayedEvalBshMethod>();
        String string2 = ClassGeneratorUtil.getBaseName(string);
        for (int i = 0; i < delayedEvalBshMethodArray.length; ++i) {
            DelayedEvalBshMethod delayedEvalBshMethod = delayedEvalBshMethodArray[i];
            if (delayedEvalBshMethod.getName().equals(string2) && ((BshMethod)delayedEvalBshMethod).getReturnType() == null) {
                arrayList.add(delayedEvalBshMethod);
                continue;
            }
            arrayList2.add(delayedEvalBshMethod);
        }
        this.constructors = arrayList.toArray(new DelayedEvalBshMethod[0]);
        this.methods = arrayList2.toArray(new DelayedEvalBshMethod[0]);
    }

    public byte[] generateClass(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = ClassGeneratorUtil.getASMModifiers(this.classModifiers) | 1;
        if (this.isInterface) {
            n4 |= 0x200;
        }
        String[] stringArray = new String[this.interfaces.length];
        for (int i = 0; i < this.interfaces.length; ++i) {
            stringArray[i] = Type.getInternalName(this.interfaces[i]);
        }
        String string = "BeanShell Generated via ASM (www.objectweb.org)";
        ClassWriter classWriter = new ClassWriter(true);
        classWriter.visit(n4, this.fqClassName, this.superClassName, stringArray, string);
        if (!this.isInterface) {
            ClassGeneratorUtil.generateField("_bshThis" + this.className, "Lbsh/This;", 1, classWriter);
            ClassGeneratorUtil.generateField("_bshStatic" + this.className, "Lbsh/This;", 9, classWriter);
        }
        for (n3 = 0; n3 < this.vars.length; ++n3) {
            String string2 = this.vars[n3].getTypeDescriptor();
            if (this.vars[n3].hasModifier("private") || string2 == null) continue;
            n2 = this.isInterface ? 25 : ClassGeneratorUtil.getASMModifiers(this.vars[n3].getModifiers());
            ClassGeneratorUtil.generateField(this.vars[n3].getName(), string2, n2, classWriter);
        }
        if (bl) {
            this.generateStaticInitializer(classWriter);
        }
        n3 = 0;
        for (n = 0; n < this.constructors.length; ++n) {
            if (this.constructors[n].hasModifier("private")) continue;
            n2 = ClassGeneratorUtil.getASMModifiers(this.constructors[n].getModifiers());
            this.generateConstructor(n, this.constructors[n].getParamTypeDescriptors(), n2, classWriter);
            n3 = 1;
        }
        if (!this.isInterface && n3 == 0) {
            this.generateConstructor(-1, new String[0], 1, classWriter);
        }
        for (n = 0; n < this.methods.length; ++n) {
            String string3 = this.methods[n].getReturnTypeDescriptor();
            if (this.methods[n].hasModifier("private")) continue;
            int n5 = ClassGeneratorUtil.getASMModifiers(this.methods[n].getModifiers());
            if (this.isInterface) {
                n5 |= 0x401;
            }
            ClassGeneratorUtil.generateMethod(this.className, this.fqClassName, this.methods[n].getName(), string3, this.methods[n].getParamTypeDescriptors(), n5, classWriter);
            boolean bl2 = (n5 & 8) > 0;
            boolean bl3 = ClassGeneratorUtil.classContainsMethod(this.superClass, this.methods[n].getName(), this.methods[n].getParamTypeDescriptors());
            if (bl2 || !bl3) continue;
            ClassGeneratorUtil.generateSuperDelegateMethod(this.superClassName, this.methods[n].getName(), string3, this.methods[n].getParamTypeDescriptors(), n5, classWriter);
        }
        return classWriter.toByteArray();
    }

    static int getASMModifiers(Modifiers modifiers) {
        int n = 0;
        if (modifiers == null) {
            return n;
        }
        if (modifiers.hasModifier("public")) {
            ++n;
        }
        if (modifiers.hasModifier("protected")) {
            n += 4;
        }
        if (modifiers.hasModifier("static")) {
            n += 8;
        }
        if (modifiers.hasModifier("synchronized")) {
            n += 32;
        }
        if (modifiers.hasModifier("abstract")) {
            n += 1024;
        }
        return n;
    }

    static void generateField(String string, String string2, int n, ClassWriter classWriter) {
        classWriter.visitField(n, string, string2, null);
    }

    static void generateMethod(String string, String string2, String string3, String string4, String[] stringArray, int n, ClassWriter classWriter) {
        boolean bl;
        String[] stringArray2 = null;
        boolean bl2 = bl = (n & 8) != 0;
        if (string4 == null) {
            string4 = "Ljava/lang/Object;";
        }
        String string5 = ClassGeneratorUtil.getMethodDescriptor(string4, stringArray);
        CodeVisitor codeVisitor = classWriter.visitMethod(n, string3, string5, stringArray2);
        if ((n & 0x400) != 0) {
            return;
        }
        if (bl) {
            ClassGeneratorUtil.pushBshStatic(string2, string, codeVisitor);
        } else {
            codeVisitor.visitVarInsn(25, 0);
            codeVisitor.visitFieldInsn(180, string2, "_bshThis" + string, "Lbsh/This;");
        }
        codeVisitor.visitLdcInsn(string3);
        ClassGeneratorUtil.generateParameterReifierCode(stringArray, bl, codeVisitor);
        codeVisitor.visitInsn(1);
        codeVisitor.visitInsn(1);
        codeVisitor.visitInsn(1);
        codeVisitor.visitInsn(4);
        codeVisitor.visitMethodInsn(182, "bsh/This", "invokeMethod", Type.getMethodDescriptor(Type.getType(Object.class), new Type[]{Type.getType(String.class), Type.getType(Object;.class), Type.getType(Interpreter.class), Type.getType(CallStack.class), Type.getType(SimpleNode.class), Type.getType(Boolean.TYPE)}));
        codeVisitor.visitMethodInsn(184, "bsh/Primitive", "unwrap", "(Ljava/lang/Object;)Ljava/lang/Object;");
        ClassGeneratorUtil.generateReturnCode(string4, codeVisitor);
        codeVisitor.visitMaxs(0, 0);
    }

    void generateConstructor(int n, String[] stringArray, int n2, ClassWriter classWriter) {
        int n3 = stringArray.length + 1;
        int n4 = stringArray.length + 2;
        String[] stringArray2 = null;
        String string = ClassGeneratorUtil.getMethodDescriptor("V", stringArray);
        CodeVisitor codeVisitor = classWriter.visitMethod(n2, "<init>", string, stringArray2);
        ClassGeneratorUtil.generateParameterReifierCode(stringArray, false, codeVisitor);
        codeVisitor.visitVarInsn(58, n3);
        this.generateConstructorSwitch(n, n3, n4, codeVisitor);
        codeVisitor.visitVarInsn(25, 0);
        codeVisitor.visitLdcInsn(this.className);
        codeVisitor.visitVarInsn(25, n3);
        codeVisitor.visitMethodInsn(184, "bsh/ClassGeneratorUtil", "initInstance", "(Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)V");
        codeVisitor.visitInsn(177);
        codeVisitor.visitMaxs(0, 0);
    }

    void generateStaticInitializer(ClassWriter classWriter) {
        CodeVisitor codeVisitor = classWriter.visitMethod(8, "<clinit>", "()V", null);
        codeVisitor.visitLdcInsn(this.fqClassName);
        codeVisitor.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        codeVisitor.visitMethodInsn(184, "bsh/ClassGeneratorUtil", "initStatic", "(Ljava/lang/Class;)V");
        codeVisitor.visitInsn(177);
        codeVisitor.visitMaxs(0, 0);
    }

    void generateConstructorSwitch(int n, int n2, int n3, CodeVisitor codeVisitor) {
        int n4;
        Label label = new Label();
        Label label2 = new Label();
        int n5 = this.superConstructors.length + this.constructors.length;
        Label[] labelArray = new Label[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            labelArray[n4] = new Label();
        }
        codeVisitor.visitLdcInsn(this.superClass.getName());
        ClassGeneratorUtil.pushBshStatic(this.fqClassName, this.className, codeVisitor);
        codeVisitor.visitVarInsn(25, n2);
        codeVisitor.visitIntInsn(16, n);
        codeVisitor.visitMethodInsn(184, "bsh/ClassGeneratorUtil", "getConstructorArgs", "(Ljava/lang/String;Lbsh/This;[Ljava/lang/Object;I)Lbsh/ClassGeneratorUtil$ConstructorArgs;");
        codeVisitor.visitVarInsn(58, n3);
        codeVisitor.visitVarInsn(25, n3);
        codeVisitor.visitFieldInsn(180, "bsh/ClassGeneratorUtil$ConstructorArgs", "selector", "I");
        codeVisitor.visitTableSwitchInsn(0, n5 - 1, label, labelArray);
        n4 = 0;
        int n6 = 0;
        while (n6 < this.superConstructors.length) {
            ClassGeneratorUtil.doSwitchBranch(n4, this.superClassName, ClassGeneratorUtil.getTypeDescriptors(this.superConstructors[n6].getParameterTypes()), label2, labelArray, n3, codeVisitor);
            ++n6;
            ++n4;
        }
        n6 = 0;
        while (n6 < this.constructors.length) {
            ClassGeneratorUtil.doSwitchBranch(n4, this.fqClassName, this.constructors[n6].getParamTypeDescriptors(), label2, labelArray, n3, codeVisitor);
            ++n6;
            ++n4;
        }
        codeVisitor.visitLabel(label);
        codeVisitor.visitVarInsn(25, 0);
        codeVisitor.visitMethodInsn(183, this.superClassName, "<init>", "()V");
        codeVisitor.visitLabel(label2);
    }

    private static void pushBshStatic(String string, String string2, CodeVisitor codeVisitor) {
        codeVisitor.visitFieldInsn(178, string, "_bshStatic" + string2, "Lbsh/This;");
    }

    static void doSwitchBranch(int n, String string, String[] stringArray, Label label, Label[] labelArray, int n2, CodeVisitor codeVisitor) {
        codeVisitor.visitLabel(labelArray[n]);
        codeVisitor.visitVarInsn(25, 0);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = null;
            string3 = string2.equals("Z") ? "getBoolean" : (string2.equals("B") ? "getByte" : (string2.equals("C") ? "getChar" : (string2.equals("S") ? "getShort" : (string2.equals("I") ? "getInt" : (string2.equals("J") ? "getLong" : (string2.equals("D") ? "getDouble" : (string2.equals("F") ? "getFloat" : "getObject")))))));
            codeVisitor.visitVarInsn(25, n2);
            String string4 = "bsh/ClassGeneratorUtil$ConstructorArgs";
            String string5 = string3.equals("getObject") ? "Ljava/lang/Object;" : string2;
            codeVisitor.visitMethodInsn(182, string4, string3, "()" + string5);
            if (!string3.equals("getObject")) continue;
            codeVisitor.visitTypeInsn(192, ClassGeneratorUtil.descriptorToClassName(string2));
        }
        String string6 = ClassGeneratorUtil.getMethodDescriptor("V", stringArray);
        codeVisitor.visitMethodInsn(183, string, "<init>", string6);
        codeVisitor.visitJumpInsn(167, label);
    }

    static String getMethodDescriptor(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(")" + string);
        return stringBuffer.toString();
    }

    static void generateSuperDelegateMethod(String string, String string2, String string3, String[] stringArray, int n, ClassWriter classWriter) {
        String[] stringArray2 = null;
        if (string3 == null) {
            string3 = "Ljava/lang/Object;";
        }
        String string4 = ClassGeneratorUtil.getMethodDescriptor(string3, stringArray);
        CodeVisitor codeVisitor = classWriter.visitMethod(n, "_bshSuper" + string2, string4, stringArray2);
        codeVisitor.visitVarInsn(25, 0);
        int n2 = 1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (ClassGeneratorUtil.isPrimitive(stringArray[i])) {
                codeVisitor.visitVarInsn(21, n2);
            } else {
                codeVisitor.visitVarInsn(25, n2);
            }
            n2 += stringArray[i].equals("D") || stringArray[i].equals("J") ? 2 : 1;
        }
        codeVisitor.visitMethodInsn(183, string, string2, string4);
        ClassGeneratorUtil.generatePlainReturnCode(string3, codeVisitor);
        codeVisitor.visitMaxs(20, 20);
    }

    static boolean classContainsMethod(Class clazz, String string, String[] stringArray) {
        while (clazz != null) {
            Method[] methodArray = clazz.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals(string)) continue;
                String[] stringArray2 = ClassGeneratorUtil.getTypeDescriptors(methodArray[i].getParameterTypes());
                boolean bl = true;
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (stringArray[j].equals(stringArray2[j])) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    static void generatePlainReturnCode(String string, CodeVisitor codeVisitor) {
        if (string.equals("V")) {
            codeVisitor.visitInsn(177);
        } else if (ClassGeneratorUtil.isPrimitive(string)) {
            int n = 172;
            if (string.equals("D")) {
                n = 175;
            } else if (string.equals("F")) {
                n = 174;
            } else if (string.equals("J")) {
                n = 173;
            }
            codeVisitor.visitInsn(n);
        } else {
            codeVisitor.visitTypeInsn(192, ClassGeneratorUtil.descriptorToClassName(string));
            codeVisitor.visitInsn(176);
        }
    }

    public static void generateParameterReifierCode(String[] stringArray, boolean bl, CodeVisitor codeVisitor) {
        codeVisitor.visitIntInsn(17, stringArray.length);
        codeVisitor.visitTypeInsn(189, "java/lang/Object");
        int n = bl ? 0 : 1;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            codeVisitor.visitInsn(89);
            codeVisitor.visitIntInsn(17, i);
            if (ClassGeneratorUtil.isPrimitive(string)) {
                int n2 = string.equals("F") ? 23 : (string.equals("D") ? 24 : (string.equals("J") ? 22 : 21));
                String string2 = "bsh/Primitive";
                codeVisitor.visitTypeInsn(187, string2);
                codeVisitor.visitInsn(89);
                codeVisitor.visitVarInsn(n2, n);
                String string3 = string;
                codeVisitor.visitMethodInsn(183, string2, "<init>", "(" + string3 + ")V");
            } else {
                codeVisitor.visitVarInsn(25, n);
            }
            codeVisitor.visitInsn(83);
            n += string.equals("D") || string.equals("J") ? 2 : 1;
        }
    }

    public static void generateReturnCode(String string, CodeVisitor codeVisitor) {
        if (string.equals("V")) {
            codeVisitor.visitInsn(87);
            codeVisitor.visitInsn(177);
        } else if (ClassGeneratorUtil.isPrimitive(string)) {
            String string2;
            String string3;
            int n = 172;
            if (string.equals("B")) {
                string3 = "java/lang/Byte";
                string2 = "byteValue";
            } else if (string.equals("I")) {
                string3 = "java/lang/Integer";
                string2 = "intValue";
            } else if (string.equals("Z")) {
                string3 = "java/lang/Boolean";
                string2 = "booleanValue";
            } else if (string.equals("D")) {
                n = 175;
                string3 = "java/lang/Double";
                string2 = "doubleValue";
            } else if (string.equals("F")) {
                n = 174;
                string3 = "java/lang/Float";
                string2 = "floatValue";
            } else if (string.equals("J")) {
                n = 173;
                string3 = "java/lang/Long";
                string2 = "longValue";
            } else if (string.equals("C")) {
                string3 = "java/lang/Character";
                string2 = "charValue";
            } else {
                string3 = "java/lang/Short";
                string2 = "shortValue";
            }
            String string4 = string;
            codeVisitor.visitTypeInsn(192, string3);
            codeVisitor.visitMethodInsn(182, string3, string2, "()" + string4);
            codeVisitor.visitInsn(n);
        } else {
            codeVisitor.visitTypeInsn(192, ClassGeneratorUtil.descriptorToClassName(string));
            codeVisitor.visitInsn(176);
        }
    }

    public static ConstructorArgs getConstructorArgs(String string, This this_, Object[] objectArray, int n) {
        int n2;
        String[] stringArray;
        Serializable serializable;
        DelayedEvalBshMethod[] delayedEvalBshMethodArray;
        Object object;
        if (this_ == null) {
            throw new InterpreterError("Unititialized class: no static");
        }
        try {
            object = this_.getNameSpace().getVariable("_bshConstructors");
            if (object == Primitive.VOID) {
                throw new InterpreterError("Unable to find constructors array in class");
            }
            delayedEvalBshMethodArray = (DelayedEvalBshMethod[])object;
        }
        catch (Exception exception) {
            throw new InterpreterError("Unable to get instance initializers: " + exception);
        }
        if (n == -1) {
            return ConstructorArgs.DEFAULT;
        }
        object = delayedEvalBshMethodArray[n];
        if (((DelayedEvalBshMethod)object).methodBody.jjtGetNumChildren() == 0) {
            return ConstructorArgs.DEFAULT;
        }
        String string2 = null;
        BSHArguments bSHArguments = null;
        SimpleNode simpleNode = (SimpleNode)((DelayedEvalBshMethod)object).methodBody.jjtGetChild(0);
        if (simpleNode instanceof BSHPrimaryExpression) {
            simpleNode = (SimpleNode)simpleNode.jjtGetChild(0);
        }
        if (simpleNode instanceof BSHMethodInvocation) {
            serializable = (BSHMethodInvocation)simpleNode;
            stringArray = ((BSHMethodInvocation)serializable).getNameNode();
            if (stringArray.text.equals("super") || stringArray.text.equals("this")) {
                string2 = stringArray.text;
                bSHArguments = ((BSHMethodInvocation)serializable).getArgsNode();
            }
        }
        if (string2 == null) {
            return ConstructorArgs.DEFAULT;
        }
        serializable = new NameSpace(this_.getNameSpace(), "consArgs");
        stringArray = ((BshMethod)object).getParameterNames();
        Class[] classArray = ((DelayedEvalBshMethod)object).getParameterTypes();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                ((NameSpace)serializable).setTypedVariable(stringArray[i], classArray[i], objectArray[i], null);
                continue;
            }
            catch (UtilEvalError utilEvalError) {
                throw new InterpreterError("err setting local cons arg:" + utilEvalError);
            }
        }
        CallStack callStack = new CallStack();
        callStack.push((NameSpace)serializable);
        Object[] objectArray2 = null;
        Interpreter interpreter = this_.declaringInterpreter;
        try {
            objectArray2 = bSHArguments.getArguments(callStack, interpreter);
        }
        catch (EvalError evalError) {
            throw new InterpreterError("Error evaluating constructor args: " + evalError);
        }
        Class[] classArray2 = Types.getTypes(objectArray2);
        objectArray2 = Primitive.unwrap(objectArray2);
        Class clazz = interpreter.getClassManager().classForName(string);
        if (clazz == null) {
            throw new InterpreterError("can't find superclass: " + string);
        }
        Constructor[] constructorArray = clazz.getDeclaredConstructors();
        if (string2.equals("super")) {
            int n3 = Reflect.findMostSpecificConstructorIndex(classArray2, constructorArray);
            if (n3 == -1) {
                throw new InterpreterError("can't find constructor for args!");
            }
            return new ConstructorArgs(n3, objectArray2);
        }
        Class[][] classArray3 = new Class[delayedEvalBshMethodArray.length][];
        for (n2 = 0; n2 < classArray3.length; ++n2) {
            classArray3[n2] = delayedEvalBshMethodArray[n2].getParameterTypes();
        }
        n2 = Reflect.findMostSpecificSignature(classArray2, classArray3);
        if (n2 == -1) {
            throw new InterpreterError("can't find constructor for args 2!");
        }
        int n4 = n2 + constructorArray.length;
        int n5 = n + constructorArray.length;
        if (n4 == n5) {
            throw new InterpreterError("Recusive constructor call.");
        }
        return new ConstructorArgs(n4, objectArray2);
    }

    public static void initInstance(Object object, String string, Object[] objectArray) {
        NameSpace nameSpace;
        Serializable serializable;
        Interpreter interpreter;
        Object object2;
        Class[] classArray = Types.getTypes(objectArray);
        CallStack callStack = new CallStack();
        This this_ = ClassGeneratorUtil.getClassInstanceThis(object, string);
        if (this_ == null) {
            object2 = ClassGeneratorUtil.getClassStaticThis(object.getClass(), string);
            if (object2 == null) {
                throw new InterpreterError("Failed to init class: " + string);
            }
            interpreter = ((This)object2).declaringInterpreter;
            try {
                serializable = (BSHBlock)((This)object2).getNameSpace().getVariable("_bshInstanceInitializer");
            }
            catch (Exception exception) {
                throw new InterpreterError("unable to get instance initializer: " + exception);
            }
            nameSpace = new NameSpace(((This)object2).getNameSpace(), string);
            nameSpace.isClass = true;
            this_ = nameSpace.getThis(interpreter);
            try {
                LHS lHS = Reflect.getLHSObjectField(object, "_bshThis" + string);
                lHS.assign(this_, false);
            }
            catch (Exception exception) {
                throw new InterpreterError("Error in class gen setup: " + exception);
            }
            nameSpace.setClassInstance(object);
            callStack.push(nameSpace);
            try {
                ((BSHBlock)serializable).evalBlock(callStack, interpreter, true, ClassGeneratorImpl.ClassNodeFilter.CLASSINSTANCE);
            }
            catch (Exception exception) {
                throw new InterpreterError("Error in class initialization: " + exception);
            }
            callStack.pop();
        } else {
            interpreter = this_.declaringInterpreter;
            nameSpace = this_.getNameSpace();
        }
        object2 = ClassGeneratorUtil.getBaseName(string);
        try {
            serializable = nameSpace.getMethod((String)object2, classArray, true);
            if (serializable != null && ((BshMethod)serializable).getReturnType() != null) {
                serializable = null;
            }
            if (objectArray.length > 0 && serializable == null) {
                throw new InterpreterError("Can't find constructor: " + string);
            }
            if (serializable != null) {
                ((BshMethod)serializable).invoke(objectArray, interpreter, callStack, null, false);
            }
        }
        catch (Exception exception) {
            Exception exception2;
            if (Interpreter.DEBUG) {
                exception.printStackTrace();
            }
            if (exception instanceof TargetError) {
                exception2 = (Exception)((TargetError)exception).getTarget();
            }
            if (exception2 instanceof InvocationTargetException) {
                exception2 = (Exception)((InvocationTargetException)exception2).getTargetException();
            }
            throw new InterpreterError("Error in class initialization: " + exception2);
        }
    }

    public static void initStatic(Class clazz) {
        ClassGeneratorUtil.startInterpreterForClass(clazz);
    }

    static This getClassStaticThis(Class clazz, String string) {
        try {
            return (This)Reflect.getStaticFieldValue(clazz, "_bshStatic" + string);
        }
        catch (Exception exception) {
            throw new InterpreterError("Unable to get class static space: " + exception);
        }
    }

    static This getClassInstanceThis(Object object, String string) {
        try {
            Object object2 = Reflect.getObjectFieldValue(object, "_bshThis" + string);
            return (This)Primitive.unwrap(object2);
        }
        catch (Exception exception) {
            throw new InterpreterError("Generated class: Error getting This" + exception);
        }
    }

    private static boolean isPrimitive(String string) {
        return string.length() == 1;
    }

    static String[] getTypeDescriptors(Class[] classArray) {
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = BSHType.getTypeDescriptor(classArray[i]);
        }
        return stringArray;
    }

    private static String descriptorToClassName(String string) {
        if (string.startsWith("[") || !string.startsWith("L")) {
            return string;
        }
        return string.substring(1, string.length() - 1);
    }

    private static String getBaseName(String string) {
        int n = string.indexOf("$");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static void startInterpreterForClass(Class clazz) {
        String string = clazz.getName();
        String string2 = Name.suffix(string, 1);
        String string3 = string2 + ".bsh";
        InputStream inputStream = clazz.getResourceAsStream(string3);
        if (inputStream == null) {
            throw new InterpreterError("Script (" + string3 + ") for BeanShell generated class: " + clazz + " not found.");
        }
        InputStreamReader inputStreamReader = new InputStreamReader(clazz.getResourceAsStream(string3));
        Interpreter interpreter = new Interpreter();
        NameSpace nameSpace = interpreter.getNameSpace();
        nameSpace.setName("class_" + string2 + "_global");
        nameSpace.getClassManager().associateClass(clazz);
        try {
            interpreter.eval(inputStreamReader, interpreter.getNameSpace(), string3);
        }
        catch (TargetError targetError) {
            System.out.println("Script threw exception: " + targetError);
            if (targetError.inNativeCode()) {
                targetError.printStackTrace(System.err);
            }
        }
        catch (EvalError evalError) {
            System.out.println("Evaluation Error: " + evalError);
        }
    }

    public static class ConstructorArgs {
        public static ConstructorArgs DEFAULT = new ConstructorArgs();
        public int selector = -1;
        Object[] args;
        int arg = 0;

        ConstructorArgs() {
        }

        ConstructorArgs(int n, Object[] objectArray) {
            this.selector = n;
            this.args = objectArray;
        }

        Object next() {
            return this.args[this.arg++];
        }

        public boolean getBoolean() {
            return (Boolean)this.next();
        }

        public byte getByte() {
            return (Byte)this.next();
        }

        public char getChar() {
            return ((Character)this.next()).charValue();
        }

        public short getShort() {
            return (Short)this.next();
        }

        public int getInt() {
            return (Integer)this.next();
        }

        public long getLong() {
            return (Long)this.next();
        }

        public double getDouble() {
            return (Double)this.next();
        }

        public float getFloat() {
            return ((Float)this.next()).floatValue();
        }

        public Object getObject() {
            return this.next();
        }
    }
}

