/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.InterpreterError;
import bsh.LHS;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.UtilEvalError;
import bsh.Variable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ExternalNameSpace
extends NameSpace {
    private Map externalMap;

    public ExternalNameSpace() {
        this(null, "External Map Namespace", null);
    }

    public ExternalNameSpace(NameSpace nameSpace, String string, Map hashMap) {
        super(nameSpace, string);
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        this.externalMap = hashMap;
    }

    public Map getMap() {
        return this.externalMap;
    }

    public void setMap(Map map) {
        this.externalMap = null;
        this.clear();
        this.externalMap = map;
    }

    public void unsetVariable(String string) {
        super.unsetVariable(string);
        this.externalMap.remove(string);
    }

    public String[] getVariableNames() {
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = super.getVariableNames();
        hashSet.addAll(Arrays.asList(stringArray));
        hashSet.addAll(this.externalMap.keySet());
        return hashSet.toArray(new String[0]);
    }

    protected Variable getVariableImpl(String string, boolean bl) throws UtilEvalError {
        Variable variable;
        Object v = this.externalMap.get(string);
        if (v == null) {
            super.unsetVariable(string);
            variable = super.getVariableImpl(string, bl);
        } else {
            Variable variable2 = super.getVariableImpl(string, false);
            variable = variable2 == null ? this.createVariable(string, null, v, null) : variable2;
        }
        return variable;
    }

    public Variable createVariable(String string, Class clazz, Object object, Modifiers modifiers) {
        LHS lHS = new LHS((Object)this.externalMap, string);
        try {
            lHS.assign(object, false);
        }
        catch (UtilEvalError utilEvalError) {
            throw new InterpreterError(utilEvalError.toString());
        }
        return new Variable(string, clazz, lHS);
    }

    public void clear() {
        super.clear();
        this.externalMap.clear();
    }
}

