/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.CollectionManager;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.NameSpace;
import bsh.ParserConstants;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.ReflectManager;
import bsh.UtilEvalError;
import bsh.UtilTargetError;
import java.io.Serializable;
import java.lang.reflect.Field;

class LHS
implements ParserConstants,
Serializable {
    NameSpace nameSpace;
    boolean localVar;
    int type;
    String varName;
    String propName;
    Field field;
    Object object;
    int index;

    LHS(NameSpace nameSpace, String string, boolean bl) {
        this.type = 0;
        this.localVar = bl;
        this.varName = string;
        this.nameSpace = nameSpace;
    }

    LHS(Field field) {
        this.type = 1;
        this.object = null;
        this.field = field;
    }

    LHS(Object object, Field field) {
        if (object == null) {
            throw new NullPointerException("constructed empty LHS");
        }
        this.type = 1;
        this.object = object;
        this.field = field;
    }

    LHS(Object object, String string) {
        if (object == null) {
            throw new NullPointerException("constructed empty LHS");
        }
        this.type = 2;
        this.object = object;
        this.propName = string;
    }

    LHS(Object object, int n) {
        if (object == null) {
            throw new NullPointerException("constructed empty LHS");
        }
        this.type = 3;
        this.object = object;
        this.index = n;
    }

    public Object getValue() throws UtilEvalError {
        if (this.type == 0) {
            return this.nameSpace.getVariableOrProperty(this.varName, null);
        }
        if (this.type == 1) {
            try {
                Object object = this.field.get(this.object);
                return Primitive.wrap(object, this.field.getType());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new UtilEvalError("Can't read field: " + this.field);
            }
        }
        if (this.type == 2) {
            CollectionManager collectionManager = CollectionManager.getCollectionManager();
            if (collectionManager.isMap(this.object)) {
                return collectionManager.getFromMap(this.object, this.propName);
            }
            try {
                return Reflect.getObjectProperty(this.object, this.propName);
            }
            catch (ReflectError reflectError) {
                Interpreter.debug(reflectError.getMessage());
                throw new UtilEvalError("No such property: " + this.propName);
            }
        }
        if (this.type == 3) {
            try {
                return Reflect.getIndex(this.object, this.index);
            }
            catch (Exception exception) {
                throw new UtilEvalError("Array access: " + exception);
            }
        }
        throw new InterpreterError("LHS type");
    }

    public Object assign(Object object, boolean bl) throws UtilEvalError {
        if (this.type == 0) {
            if (this.localVar) {
                this.nameSpace.setLocalVariableOrProperty(this.varName, object, bl);
            } else {
                this.nameSpace.setVariableOrProperty(this.varName, object, bl);
            }
        } else {
            if (this.type == 1) {
                try {
                    ReflectManager.RMSetAccessible(this.field);
                    this.field.set(this.object, Primitive.unwrap(object));
                    return object;
                }
                catch (NullPointerException nullPointerException) {
                    throw new UtilEvalError("LHS (" + this.field.getName() + ") not a static field.");
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new UtilEvalError("LHS (" + this.field.getName() + ") can't access field: " + illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    String string = object instanceof Primitive ? ((Primitive)object).getType().getName() : object.getClass().getName();
                    throw new UtilEvalError("Argument type mismatch. " + (object == null ? "null" : string) + " not assignable to field " + this.field.getName());
                }
            }
            if (this.type == 2) {
                CollectionManager collectionManager = CollectionManager.getCollectionManager();
                if (collectionManager.isMap(this.object)) {
                    collectionManager.putInMap(this.object, this.propName, Primitive.unwrap(object));
                } else {
                    try {
                        Reflect.setObjectProperty(this.object, this.propName, object);
                    }
                    catch (ReflectError reflectError) {
                        Interpreter.debug("Assignment: " + reflectError.getMessage());
                        throw new UtilEvalError("No such property: " + this.propName);
                    }
                }
            } else if (this.type == 3) {
                try {
                    Reflect.setIndex(this.object, this.index, object);
                }
                catch (UtilTargetError utilTargetError) {
                    throw utilTargetError;
                }
                catch (Exception exception) {
                    throw new UtilEvalError("Assignment: " + exception.getMessage());
                }
            } else {
                throw new InterpreterError("unknown lhs");
            }
        }
        return object;
    }

    public String toString() {
        return "LHS: " + (this.field != null ? "field = " + this.field.toString() : "") + (this.varName != null ? " varName = " + this.varName : "") + (this.nameSpace != null ? " nameSpace = " + this.nameSpace.toString() : "");
    }
}

