/*
 * Decompiled with CFR 0.152.
 */
package bsh.collection;

import bsh.BshIterator;
import bsh.CollectionManager;
import bsh.InterpreterError;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;

public class CollectionIterator
implements BshIterator {
    private Iterator iterator;

    public CollectionIterator(Object object) {
        this.iterator = this.createIterator(object);
    }

    protected Iterator createIterator(Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new NullPointerException("Object arguments passed to the CollectionIterator constructor cannot be null.");
        }
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        if (object instanceof Collection) {
            return ((Collection)object).iterator();
        }
        Iterator iterator = this.getIteratorForIterable(object);
        if (iterator != null) {
            return iterator;
        }
        final CollectionManager.BasicBshIterator basicBshIterator = new CollectionManager.BasicBshIterator(object);
        return new Iterator(){

            public boolean hasNext() {
                return basicBshIterator.hasNext();
            }

            public Object next() {
                return basicBshIterator.next();
            }

            public void remove() {
                throw new UnsupportedOperationException("remove() is not supported");
            }
        };
    }

    Iterator getIteratorForIterable(Object object) {
        Iterator iterator;
        block4: {
            iterator = null;
            try {
                Class<?> clazz = Class.forName("java.lang.Iterable");
                if (!clazz.isInstance(object)) break block4;
                try {
                    Method method = clazz.getMethod("iterator", new Class[0]);
                    iterator = (Iterator)method.invoke(object, new Object[0]);
                }
                catch (Exception exception) {
                    throw new InterpreterError("Unexpected problem calling \"iterator()\" on instance of java.lang.Iterable." + exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return iterator;
    }

    public Object next() {
        return this.iterator.next();
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }
}

