/*
 * Decompiled with CFR 0.152.
 */
package bsh.org.objectweb.asm;

import bsh.org.objectweb.asm.ByteVector;
import bsh.org.objectweb.asm.ClassVisitor;
import bsh.org.objectweb.asm.CodeVisitor;
import bsh.org.objectweb.asm.CodeWriter;
import bsh.org.objectweb.asm.Item;

public class ClassWriter
implements ClassVisitor {
    private short index = 1;
    private ByteVector pool = new ByteVector();
    private Item[] table = new Item[64];
    private int threshold = (int)(0.75 * (double)this.table.length);
    private int access;
    private int name;
    private int superName;
    private int interfaceCount;
    private int[] interfaces;
    private Item sourceFile;
    private int fieldCount;
    private ByteVector fields;
    private boolean computeMaxs;
    CodeWriter firstMethod;
    CodeWriter lastMethod;
    private int innerClassesCount;
    private ByteVector innerClasses;
    Item key = new Item();
    Item key2 = new Item();
    Item key3 = new Item();
    static byte[] TYPE;

    public ClassWriter(boolean bl) {
        this.computeMaxs = bl;
    }

    public void visit(int n, String string, String string2, String[] stringArray, String string3) {
        this.access = n;
        this.name = this.newClass((String)string).index;
        int n2 = this.superName = string2 == null ? 0 : (int)this.newClass((String)string2).index;
        if (stringArray != null && stringArray.length > 0) {
            this.interfaceCount = stringArray.length;
            this.interfaces = new int[this.interfaceCount];
            for (int i = 0; i < this.interfaceCount; ++i) {
                this.interfaces[i] = this.newClass((String)stringArray[i]).index;
            }
        }
        if (string3 != null) {
            this.newUTF8("SourceFile");
            this.sourceFile = this.newUTF8(string3);
        }
        if ((n & 0x20000) != 0) {
            this.newUTF8("Deprecated");
        }
    }

    public void visitInnerClass(String string, String string2, String string3, int n) {
        if (this.innerClasses == null) {
            this.newUTF8("InnerClasses");
            this.innerClasses = new ByteVector();
        }
        ++this.innerClassesCount;
        this.innerClasses.put2(string == null ? 0 : (int)this.newClass((String)string).index);
        this.innerClasses.put2(string2 == null ? 0 : (int)this.newClass((String)string2).index);
        this.innerClasses.put2(string3 == null ? 0 : (int)this.newUTF8((String)string3).index);
        this.innerClasses.put2(n);
    }

    public void visitField(int n, String string, String string2, Object object) {
        ++this.fieldCount;
        if (this.fields == null) {
            this.fields = new ByteVector();
        }
        this.fields.put2(n).put2(this.newUTF8((String)string).index).put2(this.newUTF8((String)string2).index);
        int n2 = 0;
        if (object != null) {
            ++n2;
        }
        if ((n & 0x10000) != 0) {
            ++n2;
        }
        if ((n & 0x20000) != 0) {
            ++n2;
        }
        this.fields.put2(n2);
        if (object != null) {
            this.fields.put2(this.newUTF8((String)"ConstantValue").index);
            this.fields.put4(2).put2(this.newCst((Object)object).index);
        }
        if ((n & 0x10000) != 0) {
            this.fields.put2(this.newUTF8((String)"Synthetic").index).put4(0);
        }
        if ((n & 0x20000) != 0) {
            this.fields.put2(this.newUTF8((String)"Deprecated").index).put4(0);
        }
    }

    public CodeVisitor visitMethod(int n, String string, String string2, String[] stringArray) {
        CodeWriter codeWriter = new CodeWriter(this, this.computeMaxs);
        codeWriter.init(n, string, string2, stringArray);
        return codeWriter;
    }

    public void visitEnd() {
    }

    public byte[] toByteArray() {
        int n = 24 + 2 * this.interfaceCount;
        if (this.fields != null) {
            n += this.fields.length;
        }
        int n2 = 0;
        CodeWriter codeWriter = this.firstMethod;
        while (codeWriter != null) {
            ++n2;
            n += codeWriter.getSize();
            codeWriter = codeWriter.next;
        }
        n += this.pool.length;
        int n3 = 0;
        if (this.sourceFile != null) {
            ++n3;
            n += 8;
        }
        if ((this.access & 0x20000) != 0) {
            ++n3;
            n += 6;
        }
        if (this.innerClasses != null) {
            ++n3;
            n += 8 + this.innerClasses.length;
        }
        ByteVector byteVector = new ByteVector(n);
        byteVector.put4(-889275714).put2(3).put2(45);
        byteVector.put2(this.index).putByteArray(this.pool.data, 0, this.pool.length);
        byteVector.put2(this.access).put2(this.name).put2(this.superName);
        byteVector.put2(this.interfaceCount);
        for (int i = 0; i < this.interfaceCount; ++i) {
            byteVector.put2(this.interfaces[i]);
        }
        byteVector.put2(this.fieldCount);
        if (this.fields != null) {
            byteVector.putByteArray(this.fields.data, 0, this.fields.length);
        }
        byteVector.put2(n2);
        codeWriter = this.firstMethod;
        while (codeWriter != null) {
            codeWriter.put(byteVector);
            codeWriter = codeWriter.next;
        }
        byteVector.put2(n3);
        if (this.sourceFile != null) {
            byteVector.put2(this.newUTF8((String)"SourceFile").index).put4(2).put2(this.sourceFile.index);
        }
        if ((this.access & 0x20000) != 0) {
            byteVector.put2(this.newUTF8((String)"Deprecated").index).put4(0);
        }
        if (this.innerClasses != null) {
            byteVector.put2(this.newUTF8((String)"InnerClasses").index);
            byteVector.put4(this.innerClasses.length + 2).put2(this.innerClassesCount);
            byteVector.putByteArray(this.innerClasses.data, 0, this.innerClasses.length);
        }
        return byteVector.data;
    }

    Item newCst(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return this.newInteger(n);
        }
        if (object instanceof Float) {
            float f = ((Float)object).floatValue();
            return this.newFloat(f);
        }
        if (object instanceof Long) {
            long l = (Long)object;
            return this.newLong(l);
        }
        if (object instanceof Double) {
            double d = (Double)object;
            return this.newDouble(d);
        }
        if (object instanceof String) {
            return this.newString((String)object);
        }
        throw new IllegalArgumentException("value " + object);
    }

    Item newUTF8(String string) {
        this.key.set(1, string, null, null);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.put1(1).putUTF(string);
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key);
            this.put(item);
        }
        return item;
    }

    Item newClass(String string) {
        this.key2.set(7, string, null, null);
        Item item = this.get(this.key2);
        if (item == null) {
            this.pool.put12(7, this.newUTF8((String)string).index);
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key2);
            this.put(item);
        }
        return item;
    }

    Item newField(String string, String string2, String string3) {
        this.key3.set(9, string, string2, string3);
        Item item = this.get(this.key3);
        if (item == null) {
            this.put122(9, this.newClass((String)string).index, this.newNameType((String)string2, (String)string3).index);
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key3);
            this.put(item);
        }
        return item;
    }

    Item newMethod(String string, String string2, String string3) {
        this.key3.set(10, string, string2, string3);
        Item item = this.get(this.key3);
        if (item == null) {
            this.put122(10, this.newClass((String)string).index, this.newNameType((String)string2, (String)string3).index);
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key3);
            this.put(item);
        }
        return item;
    }

    Item newItfMethod(String string, String string2, String string3) {
        this.key3.set(11, string, string2, string3);
        Item item = this.get(this.key3);
        if (item == null) {
            this.put122(11, this.newClass((String)string).index, this.newNameType((String)string2, (String)string3).index);
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key3);
            this.put(item);
        }
        return item;
    }

    private Item newInteger(int n) {
        this.key.set(n);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.put1(3).put4(n);
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key);
            this.put(item);
        }
        return item;
    }

    private Item newFloat(float f) {
        this.key.set(f);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.put1(4).put4(Float.floatToIntBits(f));
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key);
            this.put(item);
        }
        return item;
    }

    private Item newLong(long l) {
        this.key.set(l);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.put1(5).put8(l);
            item = new Item(this.index, this.key);
            this.put(item);
            this.index = (short)(this.index + 2);
        }
        return item;
    }

    private Item newDouble(double d) {
        this.key.set(d);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.put1(6).put8(Double.doubleToLongBits(d));
            item = new Item(this.index, this.key);
            this.put(item);
            this.index = (short)(this.index + 2);
        }
        return item;
    }

    private Item newString(String string) {
        this.key2.set(8, string, null, null);
        Item item = this.get(this.key2);
        if (item == null) {
            this.pool.put12(8, this.newUTF8((String)string).index);
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key2);
            this.put(item);
        }
        return item;
    }

    private Item newNameType(String string, String string2) {
        this.key2.set(12, string, string2, null);
        Item item = this.get(this.key2);
        if (item == null) {
            this.put122(12, this.newUTF8((String)string).index, this.newUTF8((String)string2).index);
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key2);
            this.put(item);
        }
        return item;
    }

    private Item get(Item item) {
        Item[] itemArray = this.table;
        int n = item.hashCode;
        int n2 = (n & Integer.MAX_VALUE) % itemArray.length;
        Item item2 = itemArray[n2];
        while (item2 != null) {
            if (item2.hashCode == n && item.isEqualTo(item2)) {
                return item2;
            }
            item2 = item2.next;
        }
        return null;
    }

    private void put(Item item) {
        int n;
        if (this.index > this.threshold) {
            n = this.table.length;
            Item[] itemArray = this.table;
            int n2 = n * 2 + 1;
            Item[] itemArray2 = new Item[n2];
            this.threshold = (int)((double)n2 * 0.75);
            this.table = itemArray2;
            int n3 = n;
            while (n3-- > 0) {
                Item item2 = itemArray[n3];
                while (item2 != null) {
                    Item item3 = item2;
                    item2 = item2.next;
                    int n4 = (item3.hashCode & Integer.MAX_VALUE) % n2;
                    item3.next = itemArray2[n4];
                    itemArray2[n4] = item3;
                }
            }
        }
        n = (item.hashCode & Integer.MAX_VALUE) % this.table.length;
        item.next = this.table[n];
        this.table[n] = item;
    }

    private void put122(int n, int n2, int n3) {
        this.pool.put12(n, n2).put2(n3);
    }

    static {
        byte[] byArray = new byte[220];
        String string = "AAAAAAAAAAAAAAAABCKLLDDDDDEEEEEEEEEEEEEEEEEEEEAAAAAAAADDDDDEEEEEEEEEEEEEEEEEEEEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAIIIIIIIIIIIIIIIIDNOAAAAAAGGGGGGGHAFBFAAFFAAQPIIJJIIIIIIIIIIIIIIIIII";
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(string.charAt(i) - 65);
        }
        TYPE = byArray;
    }
}

