/*
 * Decompiled with CFR 0.152.
 */
package bsh.servlet;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.servlet.SimpleTemplate;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BshServlet
extends HttpServlet {
    static String bshVersion;
    static String exampleScript;

    static String getBshVersion() {
        if (bshVersion != null) {
            return bshVersion;
        }
        Interpreter interpreter = new Interpreter();
        try {
            interpreter.eval(new InputStreamReader(BshServlet.class.getResource("getVersion.bsh").openStream()));
            bshVersion = (String)interpreter.eval("getVersion()");
        }
        catch (Exception exception) {
            bshVersion = "BeanShell: unknown version";
        }
        return bshVersion;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("bsh.script");
        String string2 = httpServletRequest.getParameter("bsh.client");
        String string3 = httpServletRequest.getParameter("bsh.servlet.output");
        String string4 = httpServletRequest.getParameter("bsh.servlet.captureOutErr");
        boolean bl = false;
        if (string4 != null && string4.equalsIgnoreCase("true")) {
            bl = true;
        }
        Object object = null;
        Exception exception = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            try {
                object = this.evalScript(string, stringBuffer, bl, httpServletRequest, httpServletResponse);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        httpServletResponse.setHeader("Bsh-Return", String.valueOf(object));
        if (string3 != null && string3.equalsIgnoreCase("raw") || string2 != null && string2.equals("Remote")) {
            this.sendRaw(httpServletRequest, httpServletResponse, exception, object, stringBuffer);
        } else {
            this.sendHTML(httpServletRequest, httpServletResponse, string, exception, object, stringBuffer, bl);
        }
    }

    void sendHTML(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Exception exception, Object object, StringBuffer stringBuffer, boolean bl) throws IOException {
        SimpleTemplate simpleTemplate = new SimpleTemplate(BshServlet.class.getResource("page.template"));
        simpleTemplate.replace("version", BshServlet.getBshVersion());
        String string2 = httpServletRequest.getRequestURI();
        simpleTemplate.replace("servletURL", string2);
        if (string != null) {
            simpleTemplate.replace("script", string);
        } else {
            simpleTemplate.replace("script", exampleScript);
        }
        if (bl) {
            simpleTemplate.replace("captureOutErr", "CHECKED");
        } else {
            simpleTemplate.replace("captureOutErr", "");
        }
        if (string != null) {
            simpleTemplate.replace("scriptResult", this.formatScriptResultHTML(string, object, exception, stringBuffer));
        }
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        simpleTemplate.write(printWriter);
        printWriter.flush();
    }

    void sendRaw(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception, Object object, StringBuffer stringBuffer) throws IOException {
        httpServletResponse.setContentType("text/plain");
        PrintWriter printWriter = httpServletResponse.getWriter();
        if (exception != null) {
            printWriter.println("Script Error:\n" + exception);
        } else {
            printWriter.println(stringBuffer.toString());
        }
        printWriter.flush();
    }

    String formatScriptResultHTML(String string, Object object, Exception exception, StringBuffer stringBuffer) throws IOException {
        SimpleTemplate simpleTemplate;
        if (exception != null) {
            String string2;
            simpleTemplate = new SimpleTemplate(this.getClass().getResource("error.template"));
            if (exception instanceof EvalError) {
                int n = ((EvalError)exception).getErrorLineNumber();
                String string3 = exception.getMessage();
                int n2 = 4;
                string2 = BshServlet.escape(string3);
                if (n > -1) {
                    string2 = string2 + "<hr>" + this.showScriptContextHTML(string, n, n2);
                }
            } else {
                string2 = BshServlet.escape(exception.toString());
            }
            simpleTemplate.replace("error", string2);
        } else {
            simpleTemplate = new SimpleTemplate(this.getClass().getResource("result.template"));
            simpleTemplate.replace("value", BshServlet.escape(String.valueOf(object)));
            simpleTemplate.replace("output", BshServlet.escape(stringBuffer.toString()));
        }
        return simpleTemplate.toString();
    }

    String showScriptContextHTML(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        int n3 = Math.max(1, n - n2);
        int n4 = n + n2;
        for (int i = 1; i <= n + n2 + 1; ++i) {
            String string2;
            if (i < n3) {
                try {
                    bufferedReader.readLine();
                    continue;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.toString());
                }
            }
            if (i > n4) break;
            try {
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
            if (string2 == null) break;
            if (i == n) {
                stringBuffer.append("<font color=\"red\">" + i + ": " + string2 + "</font><br/>");
                continue;
            }
            stringBuffer.append(i + ": " + string2 + "<br/>");
        }
        return stringBuffer.toString();
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object evalScript(String string, StringBuffer stringBuffer, boolean bl, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws EvalError {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        Interpreter interpreter = new Interpreter(null, printStream, printStream, false);
        interpreter.set("bsh.httpServletRequest", httpServletRequest);
        interpreter.set("bsh.httpServletResponse", httpServletResponse);
        Object object = null;
        Object var10_10 = null;
        PrintStream printStream2 = System.out;
        PrintStream printStream3 = System.err;
        if (bl) {
            System.setOut(printStream);
            System.setErr(printStream);
        }
        try {
            object = interpreter.eval(string);
        }
        finally {
            if (bl) {
                System.setOut(printStream2);
                System.setErr(printStream3);
            }
        }
        printStream.flush();
        stringBuffer.append(byteArrayOutputStream.toString());
        return object;
    }

    public static String escape(String string) {
        String string2 = "&<>";
        String[] stringArray = new String[]{"&amp;", "&lt;", "&gt;"};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = string2.indexOf(c);
            if (n < 0) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(stringArray[n]);
        }
        return stringBuffer.toString();
    }

    static {
        exampleScript = "print(\"hello!\");";
    }
}

