/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.chart_movingman;

import edu.colorado.phet.chart_movingman.Chart;
import edu.colorado.phet.common_movingman.view.phetgraphics.CompositePhetGraphic;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;

public abstract class AbstractGrid
extends CompositePhetGraphic {
    private double[] lines;
    private Chart chart;
    private int orientation;
    private Stroke stroke;
    private Color color;
    private double spacing;
    private double crossesOtherAxisAt;

    protected AbstractGrid(Chart chart, int n, Stroke stroke, Color color, double d, double d2) {
        this.chart = chart;
        this.orientation = n;
        this.stroke = stroke;
        this.color = color;
        this.spacing = d;
        this.crossesOtherAxisAt = d2;
    }

    public void setColor(Color color) {
        this.color = color;
        this.update();
    }

    protected abstract void update();

    public void setSpacing(double d) {
        this.spacing = d;
        this.lines = null;
        this.update();
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Color getColor() {
        return this.color;
    }

    public double getCrossesOtherAxisAt() {
        return this.crossesOtherAxisAt;
    }

    public Chart getChart() {
        return this.chart;
    }

    public double getSpacing() {
        return this.spacing;
    }

    public double[] getGridLines(double d, double d2, double d3, double d4) {
        if (this.lines != null) {
            return this.lines;
        }
        int n = (int)Math.ceil((d2 - d) / d4);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (double d5 = d + (double)n * d4; d5 <= d3; d5 += d4) {
            arrayList.add(new Double(d5));
        }
        double[] dArray = new double[arrayList.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (Double)arrayList.get(i);
        }
        return dArray;
    }

    public void setGridlines(double[] dArray) {
        this.lines = dArray;
        this.update();
    }
}

