/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.chart_movingman;

import edu.colorado.phet.chart_movingman.AbstractGrid;
import edu.colorado.phet.chart_movingman.Chart;
import edu.colorado.phet.common_movingman.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetTextGraphic;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public abstract class AbstractTicks
extends AbstractGrid {
    private int tickHeight = 6;
    private NumberFormat format = new DecimalFormat("#.#");
    private Font font = new Font("Lucida Sans", 0, 12);
    private FontMetrics fontMetrics;
    private boolean showLabels = true;
    private GraphicLayerSet tickGraphics;
    private GraphicLayerSet labelGraphics;

    public AbstractTicks(Chart chart, int n, Stroke stroke, Color color, double d) {
        this(chart, n, stroke, color, d, 0.0);
    }

    public AbstractTicks(Chart chart, int n, Stroke stroke, Color color, double d, double d2) {
        super(chart, n, stroke, color, d, d2);
        this.fontMetrics = chart.getComponent().getFontMetrics(this.font);
        this.tickGraphics = new GraphicLayerSet(chart.getComponent());
        this.labelGraphics = new GraphicLayerSet(chart.getComponent());
        this.addGraphic(this.tickGraphics);
        this.addGraphic(this.labelGraphics);
        chart.addListener(new Chart.Listener(){

            public void transformChanged(Chart chart) {
                AbstractTicks.this.update();
            }
        });
        this.update();
    }

    protected void update() {
        block3: {
            Chart chart;
            block2: {
                this.labelGraphics.clear();
                this.tickGraphics.clear();
                chart = this.getChart();
                if (this.getOrientation() != 1) break block2;
                double[] dArray = this.getGridLines(this.getCrossesOtherAxisAt(), chart.getRange().getMinX(), chart.getRange().getMaxX(), this.getSpacing());
                for (int i = 0; i < dArray.length; ++i) {
                    double d = dArray[i];
                    int n = chart.transformX(d);
                    int n2 = this.getHorizontalTickY();
                    Line2D.Double double_ = new Line2D.Double(n, n2 - this.tickHeight / 2, n, n2 + this.tickHeight / 2);
                    PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(chart.getComponent(), double_, this.getStroke(), this.getColor());
                    this.tickGraphics.addGraphic(phetShapeGraphic);
                    String string = this.format.format(d);
                    PhetTextGraphic phetTextGraphic = new PhetTextGraphic(chart.getComponent(), this.font, string, this.getColor());
                    phetTextGraphic.setLocation(n - phetTextGraphic.getWidth() / 2, n2 + this.tickHeight / 2);
                    this.labelGraphics.addGraphic(phetTextGraphic);
                }
                break block3;
            }
            if (this.getOrientation() != 2) break block3;
            double[] dArray = this.getGridLines(this.getCrossesOtherAxisAt(), chart.getRange().getMinY(), chart.getRange().getMaxY(), this.getSpacing());
            for (int i = 0; i < dArray.length; ++i) {
                double d = dArray[i];
                int n = this.getVerticalTickX();
                int n3 = chart.transformY(d);
                Line2D.Double double_ = new Line2D.Double(n - this.tickHeight / 2, n3, n + this.tickHeight / 2, n3);
                PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(chart.getComponent(), double_, this.getStroke(), this.getColor());
                this.tickGraphics.addGraphic(phetShapeGraphic);
                String string = this.format.format(d);
                PhetTextGraphic phetTextGraphic = new PhetTextGraphic(chart.getComponent(), this.font, string, this.getColor());
                phetTextGraphic.setLocation(n - this.tickHeight / 2 - phetTextGraphic.getWidth(), n3 - phetTextGraphic.getHeight() / 2);
                this.labelGraphics.addGraphic(phetTextGraphic);
            }
        }
    }

    public void setShowLabels(boolean bl) {
        this.showLabels = bl;
        this.update();
    }

    public abstract int getVerticalTickX();

    public abstract int getHorizontalTickY();
}

