/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.chart_movingman;

import edu.colorado.phet.chart_movingman.AbstractTicks;
import edu.colorado.phet.chart_movingman.Chart;
import edu.colorado.phet.common_movingman.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetShapeGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class Axis
extends GraphicLayerSet {
    private Chart chart;
    private AxisTicks minorTicks;
    private AxisTicks majorTicks;
    private int orientation;
    private double crossesOtherAxisAt = 0.0;
    private GraphicLayerSet lineGraphic;
    private Stroke stroke;
    private Color color;

    public Axis(Chart chart, int n) {
        this(chart, n, new BasicStroke(2.0f), Color.black, 2.0, 1.0);
    }

    public Axis(Chart chart, int n, Stroke stroke, Color color, double d, double d2) {
        this.minorTicks = new AxisTicks(chart, n, stroke, color, d);
        this.minorTicks.setShowLabels(false);
        this.majorTicks = new AxisTicks(chart, n, stroke, color, d2);
        this.majorTicks.setShowLabels(true);
        this.stroke = stroke;
        this.orientation = n;
        this.chart = chart;
        this.color = color;
        this.minorTicks.setVisible(false);
        this.lineGraphic = new GraphicLayerSet();
        this.addGraphic(this.lineGraphic);
        this.addGraphic(this.minorTicks);
        this.addGraphic(this.majorTicks);
        chart.addListener(new Chart.Listener(){

            public void transformChanged(Chart chart) {
                Axis.this.update();
            }
        });
        this.update();
    }

    public void update() {
        this.lineGraphic.clear();
        if (this.orientation == 1) {
            Point2D.Double double_ = new Point2D.Double(this.chart.getRange().getMinX(), this.crossesOtherAxisAt);
            Point point = this.chart.transform(double_);
            Point2D.Double double_2 = new Point2D.Double(this.chart.getRange().getMaxX(), this.crossesOtherAxisAt);
            Point point2 = this.chart.transform(double_2);
            Line2D.Double double_3 = new Line2D.Double(point.x, point.y, point2.x, point2.y);
            PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(this.chart.getComponent(), double_3, this.stroke, this.color);
            this.lineGraphic.addGraphic(phetShapeGraphic);
        } else if (this.orientation == 2) {
            Point2D.Double double_ = new Point2D.Double(this.crossesOtherAxisAt, this.chart.getRange().getMinY());
            Point point = this.chart.transform(double_);
            Point2D.Double double_4 = new Point2D.Double(this.crossesOtherAxisAt, this.chart.getRange().getMaxY());
            Point point3 = this.chart.transform(double_4);
            Line2D.Double double_5 = new Line2D.Double(point.x, point.y, point3.x, point3.y);
            PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(this.chart.getComponent(), double_5, this.stroke, this.color);
            this.lineGraphic.addGraphic(phetShapeGraphic);
        }
        this.majorTicks.update();
        this.minorTicks.update();
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setMajorTickSpacing(double d) {
        this.majorTicks.setSpacing(d);
    }

    public void setMajorGridlines(double[] dArray) {
        this.majorTicks.setGridlines(dArray);
    }

    public static class AxisTicks
    extends AbstractTicks {
        public AxisTicks(Chart chart, int n, Stroke stroke, Color color, double d) {
            super(chart, n, stroke, color, d, 0.0);
        }

        public int getVerticalTickX() {
            Point2D.Double double_ = new Point2D.Double(this.getCrossesOtherAxisAt(), this.getChart().getRange().getMinY());
            Point point = this.getChart().transform(double_);
            return point.x;
        }

        public int getHorizontalTickY() {
            Point2D.Double double_ = new Point2D.Double(this.getChart().getRange().getMinX(), this.getCrossesOtherAxisAt());
            Point point = this.getChart().transform(double_);
            return point.y;
        }
    }
}

