/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.chart_movingman;

import edu.colorado.phet.chart_movingman.Chart;
import edu.colorado.phet.common_movingman.view.BasicGraphicsSetup;
import edu.colorado.phet.common_movingman.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetImageGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class BufferedChart
extends PhetImageGraphic {
    private Chart chart;
    private ModelViewTransform2D transform2D;

    public BufferedChart(Component component, Chart chart) {
        super(component);
        this.chart = chart;
        BufferedImage bufferedImage = this.createBuffer(chart, new BasicGraphicsSetup(), 1, component.getBackground());
        this.setImage(bufferedImage);
        this.fixTransform();
    }

    private void fixTransform() {
        this.transform2D = new ModelViewTransform2D(this.chart.getModelViewTransform().getModelBounds(), this.getChartArea());
    }

    public ModelViewTransform2D getTransform2D() {
        return this.transform2D;
    }

    private BufferedImage createBuffer(Chart chart, BasicGraphicsSetup basicGraphicsSetup, int n, Color color) {
        Rectangle rectangle = chart.getBounds();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        basicGraphicsSetup.setup(graphics2D);
        graphics2D.setPaint(color);
        graphics2D.translate(-rectangle.x, -rectangle.y);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        chart.paint(graphics2D);
        return bufferedImage;
    }

    public Point toBufferCoordinates(Point2D point2D) {
        return this.transform2D.modelToView(point2D);
    }

    public Graphics2D createGraphics() {
        return super.getImage().createGraphics();
    }

    private Point getChartPosition() {
        return new Point(-this.chart.getBounds().x, -this.chart.getBounds().y);
    }

    public Rectangle getChartArea() {
        return new Rectangle(this.getChartPosition(), this.chart.getChartSize());
    }
}

