/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.chart_movingman;

import edu.colorado.phet.chart_movingman.BufferedChart;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetGraphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class BufferedLinePlot {
    private boolean visible = true;
    private boolean autorepaint = true;
    private GeneralPath generalPath;
    private Stroke stroke;
    private Paint paint;
    private BufferedChart bufferedChart;

    public BufferedLinePlot(BufferedChart bufferedChart, Stroke stroke, Paint paint) {
        this.bufferedChart = bufferedChart;
        this.stroke = stroke;
        this.paint = paint;
    }

    public Rectangle lineTo(Point2D point2D) {
        if (point2D == null) {
            throw new RuntimeException("Null point");
        }
        Point point = this.bufferedChart.toBufferCoordinates(point2D);
        if (this.generalPath == null) {
            this.generalPath = new GeneralPath();
            this.generalPath.moveTo(point.x, point.y);
            return new Rectangle(point.x, point.y, 0, 0);
        }
        Rectangle rectangle = null;
        if (this.isVisible() && this.autorepaint) {
            Line2D.Double double_ = new Line2D.Double(this.generalPath.getCurrentPoint(), point);
            rectangle = this.stroke.createStrokedShape(double_).getBounds();
            this.drawToBuffer(double_);
        }
        this.generalPath.lineTo((float)point.getX(), (float)point.getY());
        return rectangle;
    }

    private void drawToBuffer(Line2D line2D) {
        if (this.isVisible()) {
            PhetGraphics2D phetGraphics2D = this.createGraphics();
            phetGraphics2D.pushState();
            phetGraphics2D.setAntialias(true);
            phetGraphics2D.setStrokePure();
            phetGraphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            phetGraphics2D.setStroke(this.stroke);
            phetGraphics2D.setPaint(this.paint);
            Shape shape = phetGraphics2D.getClip();
            phetGraphics2D.setClip(this.getClip());
            phetGraphics2D.draw(line2D);
            phetGraphics2D.setClip(shape);
            phetGraphics2D.popState();
        }
    }

    private Shape getClip() {
        return this.bufferedChart.getChartArea();
    }

    private PhetGraphics2D createGraphics() {
        return new PhetGraphics2D(this.bufferedChart.createGraphics());
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void clear() {
        this.generalPath = null;
    }

    public void setAutoRepaint(boolean bl) {
        this.autorepaint = bl;
    }

    public void setBufferedChart(BufferedChart bufferedChart) {
        this.bufferedChart = bufferedChart;
    }
}

