/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.chart_movingman;

import java.awt.geom.Point2D;
import java.util.ArrayList;

public class DataSet {
    private ArrayList dataPoints = new ArrayList();
    private ArrayList observers = new ArrayList();

    public Point2D pointAt(int n) {
        return (Point2D)this.dataPoints.get(n);
    }

    public int size() {
        return this.dataPoints.size();
    }

    public Point2D getLastPoint() {
        if (this.size() == 0) {
            throw new RuntimeException("No such point 'last point', size=0");
        }
        return this.pointAt(this.size() - 1);
    }

    public void clear() {
        this.dataPoints.clear();
        for (int i = 0; i < this.observers.size(); ++i) {
            Observer observer = (Observer)this.observers.get(i);
            observer.cleared();
        }
    }

    public boolean isValid(Point2D point2D) {
        if (point2D == null) {
            return false;
        }
        boolean bl = Double.isNaN(point2D.getX()) || Double.isNaN(point2D.getY()) || Double.isInfinite(point2D.getX()) || Double.isInfinite(point2D.getY());
        return !bl;
    }

    public void addPoint(Point2D point2D) {
        if (!this.isValid(point2D)) {
            throw new RuntimeException("Illegal data point: " + point2D);
        }
        if (point2D == null) {
            throw new RuntimeException("Null data Point");
        }
        this.dataPoints.add(point2D);
        this.notifyObservers(point2D);
    }

    public void addPoint(double d, double d2) {
        this.addPoint(new Point2D.Double(d, d2));
    }

    private void notifyObservers(Point2D point2D) {
        for (int i = 0; i < this.observers.size(); ++i) {
            Observer observer = (Observer)this.observers.get(i);
            observer.pointAdded(point2D);
        }
    }

    public String toString() {
        return this.dataPoints.toString();
    }

    public static interface Observer {
        public void pointAdded(Point2D var1);

        public void cleared();
    }
}

