/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.chart_movingman.controllers;

import edu.colorado.phet.chart_movingman.Chart;
import edu.colorado.phet.chart_movingman.controllers.ChartSliderUI;
import edu.colorado.phet.common_movingman.math.Function$LinearFunction;
import edu.colorado.phet.common_movingman.util.EventChannel;
import edu.colorado.phet.common_movingman.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common_movingman.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_movingman.view.util.ImageLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ChartSlider
extends GraphicLayerSet {
    private Chart chart;
    private JSlider slider;
    private EventChannel eventChannel = new EventChannel(Listener.class);
    private Listener proxy = (Listener)this.eventChannel.getListenerProxy();
    private int numTicks = 1000;
    public int offsetX = 0;
    private boolean changed;
    private PhetGraphic sliderGraphic;
    private int preferredWidth;
    private ChartSliderUI sliderUI;

    public ChartSlider(Component component, Chart chart, String string, Color color) {
        super(component);
        this.chart = chart;
        this.slider = new JSlider(1, 0, this.numTicks, this.numTicks / 2){

            public GraphicsConfiguration getGraphicsConfiguration() {
                return super.getGraphicsConfiguration();
            }
        };
        this.slider.setOpaque(false);
        this.preferredWidth = this.slider.getPreferredSize().width;
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (ChartSlider.this.isDragging()) {
                    ChartSlider.this.fireChange();
                }
            }
        });
        BufferedImage bufferedImage = null;
        if (string != null) {
            try {
                bufferedImage = ImageLoader.loadBufferedImage(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (bufferedImage != null) {
            UIManager.put("Slider.trackWidth", new Integer(bufferedImage.getWidth() * 2));
            UIManager.put("Slider.majorTickLength", new Integer(6));
            UIManager.put("Slider.highlight", Color.white);
            UIManager.put("Slider.verticalThumbIcon", new ImageIcon(bufferedImage));
            UIManager.put("Slider.horizontalThumbIcon", new ImageIcon(bufferedImage));
            this.sliderUI = new ChartSliderUI(this, bufferedImage, color);
        }
        this.slider.setUI(this.sliderUI);
        this.sliderGraphic = PhetJComponent.newInstance(component, this.slider);
        this.addGraphic(this.sliderGraphic);
        this.updateLocation();
        component.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ChartSlider.this.updateLocation();
            }
        });
    }

    private boolean isDragging() {
        return this.slider.getValueIsAdjusting();
    }

    private void fireChange() {
        double d = this.getValue();
        this.proxy.valueChanged(d);
        this.changed = true;
    }

    public double getValue() {
        int n = this.slider.getValue();
        Rectangle rectangle = this.chart.getChartBounds();
        Function$LinearFunction function$LinearFunction = new Function$LinearFunction(0.0, this.numTicks, rectangle.y + rectangle.height, rectangle.y);
        double d = function$LinearFunction.evaluate(n);
        double d2 = this.chart.getModelViewTransform().viewToModelY((int)d);
        return d2;
    }

    public void updateLocation() {
        Rectangle rectangle = this.chart.getChartBounds();
        rectangle.x -= this.chart.getVerticalTicks().getWidth() - 5;
        int n = rectangle.x;
        int n2 = rectangle.y;
        Dimension dimension = this.getIconDimension();
        int n3 = dimension.height / 2;
        int n4 = dimension.width;
        Rectangle rectangle2 = new Rectangle(n - n4 - this.offsetX, n2 - n3, this.slider.getPreferredSize().width, rectangle.height + n3 * 2);
        this.slider.setPreferredSize(new Dimension(rectangle2.width, rectangle2.height));
        this.setLocation(rectangle2.x, rectangle2.y);
        this.sliderGraphic.repaint();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.slider.setPreferredSize(new Dimension(n3, n4));
        this.setLocation(n, n2);
        this.sliderGraphic.repaint();
    }

    private Dimension getIconDimension() {
        String string;
        Icon icon = UIManager.getIcon("Slider.verticalThumbIcon");
        String string2 = string = icon != null ? icon.getIconHeight() + "" : "null";
        if (icon == null) {
            return new Dimension(this.preferredWidth, this.preferredWidth);
        }
        return new Dimension(icon.getIconWidth(), icon.getIconHeight());
    }

    public void setValue(double d) {
        int n;
        double d2 = this.chart.getModelViewTransform().modelToViewY(d);
        Rectangle rectangle = this.chart.getChartBounds();
        Function$LinearFunction function$LinearFunction = new Function$LinearFunction(rectangle.y + rectangle.height, rectangle.y, 0.0, this.numTicks);
        int n2 = (int)function$LinearFunction.evaluate(d2);
        ChangeListener[] changeListenerArray = this.slider.getChangeListeners();
        for (n = 0; n < changeListenerArray.length; ++n) {
            ChangeListener changeListener = changeListenerArray[n];
            this.slider.removeChangeListener(changeListener);
        }
        n = this.slider.getValue();
        boolean bl = false;
        if (n != n2) {
            this.slider.setValue(n2);
            bl = true;
        }
        for (int i = 0; i < changeListenerArray.length; ++i) {
            ChangeListener changeListener = changeListenerArray[i];
            this.slider.addChangeListener(changeListener);
        }
        if (bl) {
            this.sliderGraphic.repaint();
        }
    }

    public void setSelected(boolean bl) {
        this.sliderUI.setSelected(bl);
    }

    public void addListener(Listener listener) {
        this.eventChannel.addListener(listener);
    }

    public PhetGraphic getSliderGraphic() {
        return this.sliderGraphic;
    }

    public static interface Listener
    extends EventListener {
        public void valueChanged(double var1);
    }
}

