/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.graphs;

import edu.colorado.phet.common.motion.MotionResources;
import edu.colorado.phet.common.motion.graphs.ControlGraphSeries;
import edu.colorado.phet.common.motion.graphs.GraphControlSeriesNode;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class GraphTimeControlNode
extends PNode {
    private PSwing goStopButton;
    private PSwing clearButton;
    private PNode seriesLayer = new PNode();
    private boolean editable = true;
    private boolean constructed = false;
    private TimeSeriesModel timeSeriesModel;

    public GraphTimeControlNode(TimeSeriesModel timeSeriesModel) {
        this.timeSeriesModel = timeSeriesModel;
        this.addChild(this.seriesLayer);
        this.goStopButton = new PSwing(new GoStopButton(timeSeriesModel));
        this.addChild(this.goStopButton);
        this.clearButton = new PSwing(new ClearButton(timeSeriesModel));
        this.addChild(this.clearButton);
        this.constructed = true;
        this.relayout();
    }

    public GraphControlSeriesNode addVariable(ControlGraphSeries controlGraphSeries) {
        GraphControlSeriesNode graphControlSeriesNode = this.createGraphControlSeriesNode(controlGraphSeries);
        graphControlSeriesNode.setEditable(this.editable);
        graphControlSeriesNode.setOffset(0.0, this.seriesLayer.getFullBounds().getHeight() + 5.0);
        this.seriesLayer.addChild(graphControlSeriesNode);
        this.relayout();
        return graphControlSeriesNode;
    }

    protected GraphControlSeriesNode createGraphControlSeriesNode(ControlGraphSeries controlGraphSeries) {
        return new GraphControlSeriesNode(controlGraphSeries);
    }

    private void relayout() {
        if (this.constructed) {
            double d = 5.0;
            this.seriesLayer.setOffset(0.0, 0.0);
            for (int i = 0; i < this.seriesLayer.getChildrenCount(); ++i) {
                GraphControlSeriesNode graphControlSeriesNode = (GraphControlSeriesNode)this.seriesLayer.getChild(i);
                graphControlSeriesNode.relayout(d);
            }
            this.goStopButton.setOffset(0.0, this.seriesLayer.getFullBounds().getMaxY() + d);
            this.clearButton.setOffset(0.0, this.goStopButton.getFullBounds().getMaxY() + d);
        }
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        for (int i = 0; i < this.seriesLayer.getChildrenCount(); ++i) {
            GraphControlSeriesNode graphControlSeriesNode = (GraphControlSeriesNode)this.seriesLayer.getChild(i);
            graphControlSeriesNode.setEditable(bl);
        }
        this.setHasChild(this.goStopButton, bl);
        this.setHasChild(this.clearButton, bl);
    }

    private void setHasChild(PNode pNode, boolean bl) {
        if (bl && !this.getChildrenReference().contains(pNode)) {
            this.addChild(pNode);
        } else if (!bl && this.getChildrenReference().contains(pNode)) {
            this.removeChild(pNode);
        }
    }

    public static class GoStopButton
    extends JButton {
        private boolean goButton = true;
        private TimeSeriesModel timeSeriesModel;

        public GoStopButton(TimeSeriesModel timeSeriesModel) {
            super("Go");
            this.timeSeriesModel = timeSeriesModel;
            this.addActionListener(new ActionListener(this, timeSeriesModel){
                private final /* synthetic */ TimeSeriesModel val$timeSeriesModel;
                private final /* synthetic */ GoStopButton this$0;
                {
                    this.this$0 = goStopButton;
                    this.val$timeSeriesModel = timeSeriesModel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (GoStopButton.access$100(this.this$0)) {
                        this.val$timeSeriesModel.startRecording();
                    } else {
                        this.val$timeSeriesModel.setPaused(true);
                    }
                }
            });
            timeSeriesModel.addListener(new TimeSeriesModel.Adapter(this){
                private final /* synthetic */ GoStopButton this$0;
                {
                    this.this$0 = goStopButton;
                }

                public void modeChanged() {
                    GoStopButton.access$200(this.this$0);
                }

                public void pauseChanged() {
                    GoStopButton.access$200(this.this$0);
                }
            });
            this.updateGoState();
        }

        private void updateGoState() {
            this.setGoButton(!this.timeSeriesModel.isRecording());
        }

        private void setGoButton(boolean bl) {
            this.goButton = bl;
            this.setText(this.goButton ? "Go!" : "Stop");
            try {
                this.setIcon(new ImageIcon(MotionResources.loadBufferedImage(this.goButton ? "go.png" : "stop.png")));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private boolean isGoButton() {
            return this.goButton;
        }

        static /* synthetic */ boolean access$100(GoStopButton goStopButton) {
            return goStopButton.isGoButton();
        }

        static /* synthetic */ void access$200(GoStopButton goStopButton) {
            goStopButton.updateGoState();
        }
    }

    public static class ClearButton
    extends JButton {
        private TimeSeriesModel graphTimeSeries;

        public ClearButton(TimeSeriesModel timeSeriesModel) {
            super("Clear");
            this.graphTimeSeries = timeSeriesModel;
            this.addActionListener(new ActionListener(this, timeSeriesModel){
                private final /* synthetic */ TimeSeriesModel val$graphTimeSeries;
                private final /* synthetic */ ClearButton this$0;
                {
                    this.this$0 = clearButton;
                    this.val$graphTimeSeries = timeSeriesModel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$graphTimeSeries.clear();
                }
            });
            timeSeriesModel.addListener(new TimeSeriesModel.Adapter(this){
                private final /* synthetic */ ClearButton this$0;
                {
                    this.this$0 = clearButton;
                }

                public void dataSeriesChanged() {
                    ClearButton.access$000(this.this$0);
                }
            });
            this.updateEnabledState();
        }

        private void updateEnabledState() {
            this.setEnabled(this.graphTimeSeries.isThereRecordedData());
        }

        static /* synthetic */ void access$000(ClearButton clearButton) {
            clearButton.updateEnabledState();
        }
    }
}

