/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.graphs;

import edu.colorado.phet.common.jfreechartphet.piccolo.JFreeChartNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;

public class JFreeChartSliderNode
extends PNode {
    private PhetPPath trackPPath;
    private PNode sliderThumb;
    private double value = 0.0;
    private ArrayList listeners = new ArrayList();
    private JFreeChartNode jFreeChartNode;

    public JFreeChartSliderNode(JFreeChartNode jFreeChartNode, final PNode pNode) {
        this.sliderThumb = pNode;
        this.sliderThumb.addInputEventListener(new CursorHandler());
        this.trackPPath = new PhetPPath(new BasicStroke(1.0f), (Paint)Color.black);
        this.addChild(this.trackPPath);
        this.addChild(pNode);
        pNode.addInputEventListener(new PBasicInputEventHandler(){
            Point2D initDragPoint = null;
            double origY;

            public void mousePressed(PInputEvent pInputEvent) {
                this.initDragPoint = pInputEvent.getPositionRelativeTo(pNode.getParent());
                this.origY = JFreeChartSliderNode.this.value < JFreeChartSliderNode.this.getMinRangeValue() ? JFreeChartSliderNode.this.getMinRangeValue() : (JFreeChartSliderNode.this.value > JFreeChartSliderNode.this.getMaxRangeValue() ? JFreeChartSliderNode.this.getMaxRangeValue() : JFreeChartSliderNode.this.value);
                JFreeChartSliderNode.this.notifySliderThumbGrabbed();
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                this.initDragPoint = null;
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                if (this.initDragPoint == null) {
                    this.mousePressed(pInputEvent);
                }
                double d = pInputEvent.getPositionRelativeTo(pNode.getParent()).getY();
                double d2 = d - this.initDragPoint.getY();
                Point2D point2D = JFreeChartSliderNode.this.nodeToPlot(new Point2D.Double(0.0, 0.0));
                Point2D point2D2 = JFreeChartSliderNode.this.nodeToPlot(new Point2D.Double(0.0, d2));
                double d3 = point2D2.getY() - point2D.getY();
                JFreeChartSliderNode.this.setValue(JFreeChartSliderNode.this.clamp(this.origY + d3));
            }
        });
        this.jFreeChartNode = jFreeChartNode;
        jFreeChartNode.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JFreeChartSliderNode.this.updateLayout();
            }
        });
        jFreeChartNode.getChart().addChangeListener(new ChartChangeListener(){

            public void chartChanged(ChartChangeEvent chartChangeEvent) {
                JFreeChartSliderNode.this.updateLayout();
            }
        });
        this.updateLayout();
    }

    private void notifySliderThumbGrabbed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.sliderThumbGrabbed();
        }
    }

    protected double getMaxRangeValue() {
        return this.jFreeChartNode.getChart().getXYPlot().getRangeAxis().getRange().getUpperBound();
    }

    protected double getMinRangeValue() {
        return this.jFreeChartNode.getChart().getXYPlot().getRangeAxis().getRange().getLowerBound();
    }

    protected Rectangle2D getDataArea() {
        this.jFreeChartNode.updateChartRenderingInfo();
        return this.jFreeChartNode.getDataArea();
    }

    protected Point2D plotToNode(Point2D.Double double_) {
        return this.jFreeChartNode.plotToNode(double_);
    }

    protected Point2D nodeToPlot(Point2D.Double double_) {
        return this.jFreeChartNode.nodeToPlot(double_);
    }

    private double clamp(double d) {
        if (d > this.getMaxRangeValue()) {
            d = this.getMaxRangeValue();
        }
        if (d < this.getMinRangeValue()) {
            d = this.getMinRangeValue();
        }
        return d;
    }

    public void setValue(double d) {
        if (this.value != d) {
            this.value = d;
            this.updateThumbLocation();
            this.notifyValueChanged();
        }
    }

    public double getValue() {
        return this.value;
    }

    protected void updateLayout() {
        Rectangle2D rectangle2D = this.getDataArea();
        this.trackPPath.setPathTo(new Rectangle2D.Double(0.0, rectangle2D.getY(), 5.0, rectangle2D.getHeight()));
        this.updateThumbLocation();
    }

    private void updateThumbLocation() {
        Point2D point2D = this.plotToNode(new Point2D.Double(0.0, this.clamp(this.value)));
        this.sliderThumb.setOffset(this.trackPPath.getFullBounds().getCenterX() - this.sliderThumb.getFullBounds().getWidth() / 2.0, point2D.getY() - this.sliderThumb.getFullBounds().getHeight() / 2.0);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void notifyValueChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.valueChanged();
        }
    }

    public static interface Listener {
        public void valueChanged();

        public void sliderThumbGrabbed();
    }
}

