/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.graphs;

import edu.colorado.phet.common.motion.graphs.ControlGraphSeries;
import edu.colorado.phet.common.motion.model.IVariable;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.ShadowHTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.ShadowPText;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.text.DecimalFormat;

public class ReadoutTitleNode
extends PNode {
    private ShadowHTMLNode titleNode;
    private ShadowPText valueNode;
    private ControlGraphSeries series;
    private DecimalFormat decimalFormat = new DefaultDecimalFormat("0.00");
    private PhetPPath background;
    private double insetX = 2.0;
    private double insetY = 2.0;

    public ReadoutTitleNode(ControlGraphSeries controlGraphSeries) {
        this.series = controlGraphSeries;
        this.titleNode = new ShadowHTMLNode();
        this.titleNode.setFont(this.getTitleFont());
        this.titleNode.setColor(controlGraphSeries.getColor());
        this.valueNode = new ShadowPText();
        this.valueNode.setFont(this.getTitleFont());
        this.valueNode.setTextPaint(controlGraphSeries.getColor());
        this.background = new PhetPPath(Color.white);
        this.addChild(this.background);
        this.addChild(this.titleNode);
        this.addChild(this.valueNode);
        this.background.translate(this.insetX, this.insetY);
        this.titleNode.translate(this.insetX, this.insetY);
        controlGraphSeries.getTemporalVariable().addListener(new IVariable.Listener(){

            public void valueChanged() {
                ReadoutTitleNode.this.updateText();
            }
        });
        controlGraphSeries.addListener(new ControlGraphSeries.Adapter(){});
        this.updateText();
        this.titleNode.setHtml("<html>" + controlGraphSeries.getAbbr() + "<sub>" + controlGraphSeries.getCharacterName() + "</sub>= ");
        this.valueNode.setOffset(this.titleNode.getFullBounds().getWidth() + 3.0, 3.0);
    }

    private Font getTitleFont() {
        if (Toolkit.getDefaultToolkit().getScreenSize().width <= 1024) {
            return new Font("Lucida Sans", 1, 11);
        }
        return new Font("Lucida Sans", 1, 14);
    }

    protected void updateText() {
        this.setValueText(this.decimalFormat.format(this.getValueToDisplay()));
    }

    private void setValueText(String string) {
        this.valueNode.setText(string + " " + this.series.getUnits());
        this.background.setPathTo(RectangleUtils.expand(this.titleNode.getFullBounds().createUnion(this.valueNode.getFullBounds()), this.insetX, this.insetY));
    }

    protected double getValueToDisplay() {
        return this.series.getTemporalVariable().getValue();
    }
}

