/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.graphs.IUpdateStrategy;
import edu.colorado.phet.common.motion.model.AccelerationDriven;
import edu.colorado.phet.common.motion.model.DefaultTemporalVariable;
import edu.colorado.phet.common.motion.model.ITemporalVariable;
import edu.colorado.phet.common.motion.model.PositionDriven;
import edu.colorado.phet.common.motion.model.TimeData;
import edu.colorado.phet.common.motion.model.UpdateStrategy;
import edu.colorado.phet.common.motion.model.VelocityDriven;

public class MotionBody
implements IUpdateStrategy {
    private ITemporalVariable x = new DefaultTemporalVariable();
    private ITemporalVariable v = new DefaultTemporalVariable();
    private ITemporalVariable a = new DefaultTemporalVariable();
    private PositionDriven positionDriven = new PositionDriven();
    private VelocityDriven velocityDriven = new VelocityDriven();
    private AccelerationDriven accelDriven = new AccelerationDriven();
    private UpdateStrategy updateStrategy = this.positionDriven;

    public void setTime(double d) {
        this.x.setPlaybackTime(d);
        this.v.setPlaybackTime(d);
        this.a.setPlaybackTime(d);
    }

    public void stepInTime(double d, double d2) {
        this.updateStrategy.update(this, d2, d);
    }

    public void setPosition(double d) {
        this.x.setValue(d);
    }

    public void clear() {
        this.x.clear();
        this.v.clear();
        this.a.clear();
    }

    public double getAcceleration() {
        return this.a.getValue();
    }

    public double getVelocity() {
        return this.v.getValue();
    }

    public double getPosition() {
        return this.x.getValue();
    }

    public ITemporalVariable getPositionVariable() {
        return this.x;
    }

    public ITemporalVariable getVelocityVariable() {
        return this.v;
    }

    public ITemporalVariable getAccelerationVariable() {
        return this.a;
    }

    public void setUpdateStrategy(UpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public void setPositionDriven() {
        this.setUpdateStrategy(this.positionDriven);
    }

    public PositionDriven getPositionDriven() {
        return this.positionDriven;
    }

    public VelocityDriven getVelocityDriven() {
        return this.velocityDriven;
    }

    public AccelerationDriven getAccelDriven() {
        return this.accelDriven;
    }

    public void addPositionData(double d, double d2) {
        this.x.addValue(d, d2);
    }

    public void addVelocityData(double d, double d2) {
        this.v.addValue(d, d2);
    }

    public void addAccelerationData(double d, double d2) {
        this.a.addValue(d, d2);
    }

    public TimeData[] getRecentVelocityTimeSeries(int n) {
        return this.v.getRecentSeries(n);
    }

    public TimeData[] getRecentPositionTimeSeries(int n) {
        return this.x.getRecentSeries(n);
    }

    public int getAccelerationSampleCount() {
        return this.a.getSampleCount();
    }

    public int getVelocitySampleCount() {
        return this.v.getSampleCount();
    }

    public int getPositionSampleCount() {
        return this.x.getSampleCount();
    }
}

