/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.model.DefaultTemporalVariable;
import edu.colorado.phet.common.motion.model.ITemporalVariable;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.timeseries.model.RecordableModel;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.colorado.phet.common.timeseries.model.TimeState;

public class MotionModel {
    private TimeSeriesModel timeSeriesModel;
    private ITemporalVariable timeVariable = new DefaultTemporalVariable();

    public MotionModel(ConstantDtClock constantDtClock) {
        RecordableModel recordableModel = new RecordableModel(){

            public void stepInTime(double d) {
                MotionModel.this.stepInTime(d);
            }

            public Object getState() {
                return new Double(MotionModel.this.timeVariable.getValue());
            }

            public void setState(Object object) {
                MotionModel.this.setPlaybackTime((Double)object);
            }

            public void clear() {
                MotionModel.this.clear();
            }
        };
        this.timeSeriesModel = new TimeSeriesModel(recordableModel, constantDtClock){

            public void rewind() {
                this.setPlaybackMode();
                super.rewind();
            }
        };
        this.timeSeriesModel.addListener(new TimeSeriesModel.Adapter(){

            public void modeChanged() {
                TimeState timeState;
                if (MotionModel.this.timeSeriesModel.isRecordMode() && (timeState = MotionModel.this.timeSeriesModel.getSeries().getLastPoint()) != null) {
                    Object object = timeState.getValue();
                    MotionModel.this.setPlaybackTime((Double)object);
                }
            }
        });
        this.timeSeriesModel.setRecordMode();
        constantDtClock.addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                MotionModel.this.timeSeriesModel.stepMode(clockEvent.getSimulationTimeChange());
            }
        });
    }

    protected void setPlaybackTime(double d) {
        this.timeVariable.setPlaybackTime(d);
    }

    public void stepInTime(double d) {
        double d2 = this.timeVariable.getValue() + d;
        this.timeVariable.addValue(d2, d2);
    }

    public void clear() {
        this.timeVariable.setValue(0.0);
        this.timeVariable.clear();
        this.timeSeriesModel.clear();
    }

    public double getTime() {
        return this.timeVariable.getValue();
    }

    public TimeSeriesModel getTimeSeriesModel() {
        return this.timeSeriesModel;
    }

    public void setMaxAllowedRecordTime(double d) {
        this.getTimeSeriesModel().setMaxAllowedRecordTime(d);
    }
}

