/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.MotionMath;
import edu.colorado.phet.common.motion.model.MotionBody;
import edu.colorado.phet.common.motion.model.TimeData;
import edu.colorado.phet.common.motion.model.UpdateStrategy;

public class PositionDriven
implements UpdateStrategy {
    private int velocityWindow = 6;
    private int accelerationWindow = 6;

    public void update(MotionBody motionBody, double d, double d2) {
        TimeData timeData = MotionMath.getDerivative(MotionMath.smooth(motionBody.getRecentPositionTimeSeries(Math.min(this.velocityWindow, motionBody.getPositionSampleCount())), 1));
        TimeData timeData2 = MotionMath.getDerivative(MotionMath.smooth(motionBody.getRecentVelocityTimeSeries(Math.min(this.accelerationWindow, motionBody.getVelocitySampleCount())), 1));
        motionBody.addPositionData(motionBody.getPosition(), d2);
        motionBody.addVelocityData(timeData.getValue(), timeData.getTime());
        motionBody.addAccelerationData(timeData2.getValue(), timeData2.getTime());
    }
}

