/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.graphs.IUpdateStrategy;
import edu.colorado.phet.common.motion.model.AccelerationDriven;
import edu.colorado.phet.common.motion.model.ITemporalVariable;
import edu.colorado.phet.common.motion.model.MotionBody;
import edu.colorado.phet.common.motion.model.MotionModel;
import edu.colorado.phet.common.motion.model.PositionDriven;
import edu.colorado.phet.common.motion.model.UpdateStrategy;
import edu.colorado.phet.common.motion.model.VelocityDriven;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;

public class SingleBodyMotionModel
extends MotionModel
implements IUpdateStrategy {
    private MotionBody motionBody = new MotionBody();

    public SingleBodyMotionModel(ConstantDtClock constantDtClock) {
        super(constantDtClock);
    }

    protected void setPlaybackTime(double d) {
        super.setPlaybackTime(d);
        this.motionBody.setTime(d);
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        this.motionBody.stepInTime(this.getTime(), d);
    }

    public void clear() {
        super.clear();
        this.motionBody.clear();
    }

    public ITemporalVariable getXVariable() {
        return this.motionBody.getPositionVariable();
    }

    public ITemporalVariable getVVariable() {
        return this.motionBody.getVelocityVariable();
    }

    public ITemporalVariable getAVariable() {
        return this.motionBody.getAccelerationVariable();
    }

    public MotionBody getMotionBody() {
        return this.motionBody;
    }

    public void setPositionDriven() {
        this.motionBody.setPositionDriven();
    }

    public PositionDriven getPositionDriven() {
        return this.motionBody.getPositionDriven();
    }

    public VelocityDriven getVelocityDriven() {
        return this.motionBody.getVelocityDriven();
    }

    public AccelerationDriven getAccelDriven() {
        return this.motionBody.getAccelDriven();
    }

    public void setUpdateStrategy(UpdateStrategy updateStrategy) {
        this.motionBody.setUpdateStrategy(updateStrategy);
    }
}

