/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.model;

import edu.colorado.phet.common.motion.MotionMath;
import edu.colorado.phet.common.motion.model.MotionBody;
import edu.colorado.phet.common.motion.model.TimeData;
import edu.colorado.phet.common.motion.model.UpdateStrategy;

public class VelocityDriven
implements UpdateStrategy {
    int velWindow = 10;

    public void update(MotionBody motionBody, double d, double d2) {
        double d3 = motionBody.getPosition() + motionBody.getVelocity() * d;
        TimeData timeData = MotionMath.getDerivative(motionBody.getRecentVelocityTimeSeries(Math.min(this.velWindow, motionBody.getAccelerationSampleCount())));
        motionBody.addPositionData(d3, d2);
        motionBody.addVelocityData(motionBody.getVelocity(), d2);
        motionBody.addAccelerationData(timeData.getValue(), timeData.getTime() + d);
    }
}

