/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import edu.colorado.phet.common.phetcommon.servicemanager.PhetServiceManager;
import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.FrameSetup;
import edu.colorado.phet.common.phetcommon.view.util.PhetDefaultFont;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.html.HTMLEditorKit;

public class PhetAboutDialog
extends JDialog {
    private JPanel logoPanel;
    private String titleString;
    private String descriptionString;
    private String versionString;
    private String creditsString;

    public PhetAboutDialog(Frame frame, String string) {
        this(frame, new PhetApplicationConfigDialogConfig(new PhetApplicationConfig(new String[0], new FrameSetup.NoOp(), PhetResources.forProject(string))));
    }

    public PhetAboutDialog(Frame frame, DialogConfig dialogConfig) {
        super(frame);
        this.setResizable(false);
        this.titleString = dialogConfig.getName();
        this.descriptionString = dialogConfig.getDescription();
        this.versionString = dialogConfig.getVersionForAboutDialog();
        this.creditsString = dialogConfig.getCredits();
        this.setTitle(this.getLocalizedString("Common.HelpMenu.AboutTitle") + " " + this.titleString);
        this.logoPanel = this.createLogoPanel();
        JPanel jPanel = this.createInfoPanel();
        JPanel jPanel2 = this.createButtonPanel();
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.setFillHorizontal();
        verticalLayoutPanel.add(this.logoPanel);
        verticalLayoutPanel.add(new JSeparator());
        verticalLayoutPanel.add(jPanel);
        verticalLayoutPanel.add(new JSeparator());
        verticalLayoutPanel.add(jPanel2);
        this.setContentPane(verticalLayoutPanel);
        this.pack();
        SwingUtils.centerDialogInParent(this);
    }

    private JPanel createLogoPanel() {
        BufferedImage bufferedImage = PhetCommonResources.getInstance().getImage("logos/phet-logo-120x50.jpg");
        JLabel jLabel = new JLabel(new ImageIcon(bufferedImage));
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        jLabel.setToolTipText(this.getLocalizedString("Common.About.WebLink"));
        jLabel.addMouseListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                PhetServiceManager.showPhetPage();
            }
        });
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditorKit(new HTMLEditorKit());
        String string = this.getLocalizedString("Common.About.Copyright");
        string = string.replaceAll("@FONT_SIZE@", new PhetDefaultFont().getSize() + "pt");
        string = string.replaceAll("@FONT_FAMILY@", new PhetDefaultFont().getFamily());
        jEditorPane.setText(string);
        jEditorPane.setEditable(false);
        jEditorPane.setBackground(new JLabel().getBackground());
        jEditorPane.setFont(new PhetDefaultFont(1, 24));
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    PhetServiceManager.showPhetPage();
                }
            }
        });
        HorizontalLayoutPanel horizontalLayoutPanel = new HorizontalLayoutPanel();
        horizontalLayoutPanel.setInsets(new Insets(10, 10, 10, 10));
        horizontalLayoutPanel.add(jLabel);
        horizontalLayoutPanel.add(jEditorPane);
        return horizontalLayoutPanel;
    }

    private JPanel createInfoPanel() {
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        JLabel jLabel = new JLabel(this.titleString);
        Font font = jLabel.getFont();
        jLabel.setFont(new Font(font.getFontName(), 1, font.getSize()));
        JTextArea jTextArea = new JTextArea(this.descriptionString);
        FontMetrics fontMetrics = jTextArea.getFontMetrics(jTextArea.getFont());
        jTextArea.setColumns(35);
        int n = fontMetrics.stringWidth(this.descriptionString) / fontMetrics.charWidth('m') / 35 + 2;
        jTextArea.setRows(n);
        jTextArea.setBackground(verticalLayoutPanel.getBackground());
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        String string = this.getLocalizedString("Common.About.Version") + " ";
        JLabel jLabel2 = new JLabel(string + this.versionString);
        String string2 = this.getLocalizedString("Common.About.JavaVersion") + " " + System.getProperty("java.version");
        JLabel jLabel3 = new JLabel(string2);
        int n2 = 10;
        int n3 = 10;
        verticalLayoutPanel.setInsets(new Insets(0, n2, 0, n2));
        verticalLayoutPanel.add(Box.createVerticalStrut(n3));
        verticalLayoutPanel.add(jLabel);
        verticalLayoutPanel.add(Box.createVerticalStrut(n3));
        verticalLayoutPanel.add(jTextArea);
        verticalLayoutPanel.add(Box.createVerticalStrut(n3));
        verticalLayoutPanel.add(jLabel2);
        verticalLayoutPanel.add(jLabel3);
        verticalLayoutPanel.add(Box.createVerticalStrut(n3));
        return verticalLayoutPanel;
    }

    private JPanel createButtonPanel() {
        JButton jButton = new JButton(this.getLocalizedString("Common.About.LicenseButton"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhetAboutDialog.this.showLicenseInfo();
            }
        });
        JButton jButton2 = new JButton(this.getLocalizedString("Common.About.CreditsButton"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhetAboutDialog.this.showCredits();
            }
        });
        JButton jButton3 = new JButton(this.getLocalizedString("Common.About.OKButton"));
        this.getRootPane().setDefaultButton(jButton3);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhetAboutDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(jButton);
        if (this.creditsString != null) {
            jPanel.add(jButton2);
        }
        jPanel.add(jButton3);
        return jPanel;
    }

    protected void showLicenseInfo() {
        String string = PhetAboutDialog.readFile("phet-license.txt");
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setColumns(45);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        this.showMessageDialog(jTextArea, this.getLocalizedString("Common.About.LicenseDialog.Title"));
    }

    protected void showCredits() {
        JLabel jLabel = new JLabel(this.creditsString);
        this.showMessageDialog(jLabel, this.getLocalizedString("Common.About.CreditsDialog.Title"));
    }

    private String getLocalizedString(String string) {
        return PhetCommonResources.getInstance().getLocalizedString(string);
    }

    protected void showMessageDialog(Component component, String string) {
        JOptionPane jOptionPane = new JOptionPane(component, 1);
        JDialog jDialog = jOptionPane.createDialog(null, string);
        component.invalidate();
        jDialog.pack();
        jDialog.show();
    }

    private static String readFile(String string) {
        String string2 = new String();
        try {
            URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
            if (uRL == null) {
                new FileNotFoundException(string).printStackTrace();
                return "";
            }
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                string2 = string2 + string3;
                string3 = bufferedReader.readLine();
                if (string3 == null) continue;
                string2 = string2 + System.getProperty("line.separator");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string2;
    }

    public static class PhetApplicationConfigDialogConfig
    implements DialogConfig {
        private PhetApplicationConfig applicationConfig;

        public PhetApplicationConfigDialogConfig(PhetApplicationConfig phetApplicationConfig) {
            this.applicationConfig = phetApplicationConfig;
        }

        public String getName() {
            return this.applicationConfig.getName();
        }

        public String getDescription() {
            return this.applicationConfig.getDescription();
        }

        public String getVersionForAboutDialog() {
            return this.applicationConfig.getVersion().formatForAboutDialog();
        }

        public String getCredits() {
            return this.applicationConfig.getCredits();
        }
    }

    public static interface DialogConfig {
        public String getName();

        public String getDescription();

        public String getVersionForAboutDialog();

        public String getCredits();
    }
}

