/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class FlavorLauncher
extends JFrame {
    private String[] _args;
    private SimulationInfo[] info;
    private SimulationInfo selectedSim;
    static /* synthetic */ Class array$Ljava$lang$String;

    public FlavorLauncher(String[] stringArray, SimulationInfo[] simulationInfoArray) {
        this._args = stringArray;
        this.info = simulationInfoArray;
        this.createUI();
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
    }

    private void createUI() {
        JComponent jComponent = this.createInputPanel();
        JPanel jPanel = this.createActionsPanel();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JSeparator(), "North");
        jPanel2.add((Component)jPanel, "Center");
        BorderLayout borderLayout = new BorderLayout(20, 20);
        JPanel jPanel3 = new JPanel(borderLayout);
        jPanel3.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel3.add((Component)jComponent, "Center");
        jPanel3.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel3);
        this.pack();
        if ((double)this.getHeight() > (double)Toolkit.getDefaultToolkit().getScreenSize().height * 0.75) {
            this.setSize(this.getWidth(), (int)((double)Toolkit.getDefaultToolkit().getScreenSize().height * 0.75));
        }
    }

    private JComponent createInputPanel() {
        JLabel jLabel = new JLabel("<html>This program contains " + this.info.length + " simulations.<br>" + "Select the simulation that you wish to start:<br>" + "</html>");
        JPanel jPanel = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        jPanel.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(jLabel, n++, n2);
        ButtonGroup buttonGroup = new ButtonGroup();
        int n3 = 0;
        while (n3 < this.info.length) {
            String string = this.info[n3].getTitle();
            if (string == null || string.trim().length() == 0) {
                string = this.info[n3].getMainClass().substring(this.info[n3].getMainClass().lastIndexOf(46) + 1);
            }
            JRadioButton jRadioButton = new JRadioButton(string, n3 == 0);
            final int n4 = n3++;
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FlavorLauncher.this.selectedSim = FlavorLauncher.this.info[n4];
                }
            });
            buttonGroup.add(jRadioButton);
            easyGridBagLayout.addComponent(jRadioButton, n++, n2);
        }
        this.selectedSim = this.info[0];
        if (this.info.length > 10) {
            return new JScrollPane(jPanel);
        }
        return jPanel;
    }

    protected JPanel createActionsPanel() {
        JButton jButton = new JButton("Start");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FlavorLauncher.this.handleStart();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FlavorLauncher.this.handleCancel();
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 0));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private void handleCancel() {
        this.dispose();
        System.exit(0);
    }

    private void handleStart() {
        try {
            this.selectedSim.launch();
            this.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, exception.toString(), "Exception", 0);
        }
    }

    public static void main(String[] stringArray) throws IOException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        Properties properties = new Properties();
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("flavors.properties");
        if (uRL != null) {
            properties.load(uRL.openStream());
        } else {
            properties.load(new FileInputStream(new File("flavors.properties")));
        }
        SimulationInfo[] simulationInfoArray = FlavorLauncher.getSimInfo(properties);
        if (simulationInfoArray.length == 0) {
            throw new RuntimeException("No flavors found.");
        }
        URL uRL2 = Thread.currentThread().getContextClassLoader().getResource("main-flavor.properties");
        if (uRL2 != null) {
            Properties properties2 = new Properties();
            properties2.load(uRL2.openStream());
            String string = properties2.getProperty("main.flavor");
            System.out.println("Launching: " + string);
            FlavorLauncher.launchFlavor(simulationInfoArray, string);
        } else if (simulationInfoArray.length == 1) {
            System.out.println("Found one flavor: " + simulationInfoArray[0].getTitle());
            System.out.println("Launching...");
            simulationInfoArray[0].launch();
        } else {
            FlavorLauncher flavorLauncher = new FlavorLauncher(stringArray, simulationInfoArray);
            SwingUtils.centerWindowOnScreen(flavorLauncher);
            flavorLauncher.show();
        }
    }

    private static void launchFlavor(SimulationInfo[] simulationInfoArray, String string) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        for (int i = 0; i < simulationInfoArray.length; ++i) {
            SimulationInfo simulationInfo = simulationInfoArray[i];
            if (!simulationInfo.getFlavor().equals(string)) continue;
            simulationInfo.launch();
        }
    }

    private static String[] listFlavors(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        HashSet<String> hashSet = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            String string;
            int n;
            String string2 = (String)enumeration.nextElement();
            if (!string2.toLowerCase().startsWith("project.flavor") || (n = (string = string2.substring("project.flavor.".length())).indexOf(46)) < 0) continue;
            String string3 = string.substring(0, n);
            hashSet.add(string3);
        }
        return hashSet.toArray(new String[0]);
    }

    private static SimulationInfo[] getSimInfo(Properties properties) {
        String[] stringArray = FlavorLauncher.listFlavors(properties);
        ArrayList<SimulationInfo> arrayList = new ArrayList<SimulationInfo>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            SimulationInfo simulationInfo = FlavorLauncher.getFlavor(properties, string);
            arrayList.add(simulationInfo);
        }
        return arrayList.toArray(new SimulationInfo[0]);
    }

    private static SimulationInfo getFlavor(Properties properties, String string) {
        String string2 = properties.getProperty("project.flavor." + string + ".mainclass");
        String string3 = properties.getProperty("project.flavor." + string + ".title");
        String string4 = properties.getProperty("project.flavor." + string + ".args");
        return new SimulationInfo(string, string3, string2, string4);
    }

    static class SimulationInfo {
        private String flavor;
        private String title;
        private String mainClass;
        private String args;

        public SimulationInfo(String string, String string2, String string3, String string4) {
            this.flavor = string;
            this.title = string2;
            this.mainClass = string3;
            this.args = string4;
        }

        public String getTitle() {
            return this.title;
        }

        public String getMainClass() {
            return this.mainClass;
        }

        public String[] getArgArray() {
            StringTokenizer stringTokenizer = new StringTokenizer(this.args);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return arrayList.toArray(new String[0]);
        }

        public void launch() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            Class<?> clazz = Class.forName(this.getMainClass());
            Method method = clazz.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = FlavorLauncher.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            Thread thread = new Thread(new Runnable(this, method){
                private final /* synthetic */ Method val$main;
                private final /* synthetic */ SimulationInfo this$0;
                {
                    this.this$0 = simulationInfo;
                    this.val$main = method;
                }

                public void run() {
                    try {
                        this.val$main.invoke(null, new Object[]{this.this$0.getArgArray()});
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                }
            });
            thread.start();
        }

        public String getFlavor() {
            return this.flavor;
        }
    }
}

