/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.timeseries.ui;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.MultiStateButton;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.colorado.phet.common.timeseries.ui.TimeSpeedSlider;
import edu.colorado.phet.common.timeseries.ui.TimeseriesResources;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimeSeriesControlPanel
extends JPanel {
    protected MultiStateButton recordButton;
    protected ConstantDtClock clock;
    protected TimeSeriesModel timeSeriesModel;
    protected JButton rewindButton;
    protected MultiStateButton playbackButton;
    protected JButton stepButton;
    protected static final Object KEY_REC = "rec";
    protected static final Object KEY_PAUSE_REC = "pause-rec";
    private TimeSpeedSlider timeSpeedSlider;

    public TimeSeriesControlPanel(final TimeSeriesModel timeSeriesModel, double d, double d2) {
        this.clock = timeSeriesModel.getTimeModelClock();
        this.timeSeriesModel = timeSeriesModel;
        this.timeSpeedSlider = new TimeSpeedSlider(d, d2, "0.00", this.clock);
        this.timeSpeedSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TimeSeriesControlPanel.this.clock.setDt(TimeSeriesControlPanel.this.timeSpeedSlider.getValue());
            }
        });
        this.clock.addConstantDtClockListener(new ConstantDtClock.ConstantDtClockAdapter(){

            public void dtChanged(ConstantDtClock.ConstantDtClockEvent constantDtClockEvent) {
                TimeSeriesControlPanel.this.timeSpeedSlider.setValue(TimeSeriesControlPanel.this.clock.getDt());
            }
        });
        this.add(this.timeSpeedSlider);
        try {
            this.recordButton = new MultiStateButton(new Object[]{KEY_REC, KEY_PAUSE_REC}, new String[]{"REC", "Pause"}, new Icon[]{new ImageIcon(ImageLoader.loadBufferedImage("timeseries/images/icons/record24.gif")), this.loadCommonIcon("clock/Pause24.gif")});
            this.recordButton.addActionListener(KEY_REC, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    timeSeriesModel.setRecordMode();
                    TimeSeriesControlPanel.this.clock.start();
                }
            });
            this.recordButton.addActionListener(KEY_PAUSE_REC, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TimeSeriesControlPanel.this.clock.pause();
                }
            });
            this.add(this.recordButton);
            timeSeriesModel.addListener(new TimeSeriesModel.Adapter(){

                public void modeChanged() {
                    TimeSeriesControlPanel.this.updateRecordButton();
                }
            });
            this.clock.addClockListener(new ClockAdapter(){

                public void clockPaused(ClockEvent clockEvent) {
                    TimeSeriesControlPanel.this.updateRecordButton();
                }

                public void clockStarted(ClockEvent clockEvent) {
                    TimeSeriesControlPanel.this.updateRecordButton();
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.playbackButton = new MultiStateButton(new Object[]{"playback", "pause"}, new String[]{"Playback", "Pause"}, new Icon[]{this.loadCommonIcon("clock/Play24.gif"), this.loadCommonIcon("clock/Pause24.gif")});
        this.playbackButton.addActionListener("playback", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (timeSeriesModel.isRecording()) {
                    timeSeriesModel.setPlaybackMode();
                    timeSeriesModel.setPlaybackTime(0.0);
                }
                if (timeSeriesModel.getPlaybackTime() == timeSeriesModel.getRecordTime()) {
                    timeSeriesModel.setPlaybackTime(0.0);
                }
                timeSeriesModel.setPlaybackMode();
                TimeSeriesControlPanel.this.clock.start();
            }
        });
        this.playbackButton.addActionListener("pause", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TimeSeriesControlPanel.this.clock.pause();
            }
        });
        this.clock.addClockListener(new ClockAdapter(){

            public void clockStarted(ClockEvent clockEvent) {
                TimeSeriesControlPanel.this.updatePlaybackButtonMode();
            }

            public void clockPaused(ClockEvent clockEvent) {
                TimeSeriesControlPanel.this.updatePlaybackButtonMode();
            }
        });
        timeSeriesModel.addListener(new TimeSeriesModel.Adapter(){

            public void modeChanged() {
                TimeSeriesControlPanel.this.updatePlaybackButtonMode();
            }

            public void pauseChanged() {
                TimeSeriesControlPanel.this.updatePlaybackButtonMode();
            }
        });
        this.stepButton = new JButton("Step", this.loadCommonIcon("clock/StepForward24.gif"));
        this.stepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TimeSeriesControlPanel.this.clock.stepClockWhilePaused();
            }
        });
        this.add(this.playbackButton);
        this.add(this.stepButton);
        this.clock.addClockListener(new ClockAdapter(){

            public void clockStarted(ClockEvent clockEvent) {
                TimeSeriesControlPanel.this.updateStepEnabled();
            }

            public void clockPaused(ClockEvent clockEvent) {
                TimeSeriesControlPanel.this.updateStepEnabled();
            }
        });
        timeSeriesModel.addPlaybackTimeChangeListener(new TimeSeriesModel.PlaybackTimeListener(){

            public void timeChanged() {
                TimeSeriesControlPanel.this.updateStepEnabled();
            }
        });
        this.rewindButton = new JButton(TimeseriesResources.getString("rewind"), new ImageIcon(PhetCommonResources.getInstance().getImage("clock/Rewind24.gif")));
        this.rewindButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                timeSeriesModel.rewind();
            }
        });
        this.add(this.rewindButton);
        this.clock.addClockListener(new ClockAdapter(){

            public void clockPaused(ClockEvent clockEvent) {
                TimeSeriesControlPanel.this.updateRewindButtonEnabled();
            }

            public void clockStarted(ClockEvent clockEvent) {
                TimeSeriesControlPanel.this.updateRewindButtonEnabled();
            }
        });
        JButton jButton = new JButton("Clear", new ImageIcon(PhetCommonResources.getInstance().getImage("clock/Stop24.gif")));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                timeSeriesModel.clear();
            }
        });
        this.add(jButton);
        this.updateRecordButton();
    }

    protected void updateStepEnabled() {
        boolean bl;
        boolean bl2 = bl = this.timeSeriesModel.getPlaybackTime() == this.timeSeriesModel.getRecordTime();
        if (bl || this.clock.isRunning()) {
            this.stepButton.setEnabled(false);
        } else {
            this.stepButton.setEnabled(true);
        }
    }

    protected void updatePlaybackButtonMode() {
        if (this.clock.isPaused() || this.timeSeriesModel.isRecording() || this.timeSeriesModel.isLiveMode()) {
            this.playbackButton.setMode("playback");
        } else {
            this.playbackButton.setMode("pause");
        }
    }

    protected Icon loadCommonIcon(String string) {
        return new ImageIcon(PhetCommonResources.getInstance().getImage(string));
    }

    protected void updateRewindButtonEnabled() {
        this.rewindButton.setEnabled(this.clock.isPaused());
    }

    protected void updateRecordButton() {
        if (this.clock.isPaused() || this.timeSeriesModel.isPlaybackMode() || this.timeSeriesModel.isLiveMode()) {
            this.recordButton.setMode(KEY_REC);
        } else {
            this.recordButton.setMode(KEY_PAUSE_REC);
        }
    }
}

