/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_movingman.application;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_movingman.application.PhetApplication;
import edu.colorado.phet.common_movingman.model.BaseModel;
import edu.colorado.phet.common_movingman.model.clock.AbstractClock;
import edu.colorado.phet.common_movingman.model.clock.ClockTickEvent;
import edu.colorado.phet.common_movingman.model.clock.ClockTickListener;
import edu.colorado.phet.common_movingman.view.ApparatusPanel;
import edu.colorado.phet.common_movingman.view.help.HelpManager;
import javax.swing.JPanel;

public class Module
implements ClockTickListener {
    BaseModel model;
    ApparatusPanel apparatusPanel;
    JPanel controlPanel;
    JPanel monitorPanel;
    String name;
    private AbstractClock clock;
    HelpManager helpManager;

    protected Module(String string, AbstractClock abstractClock) {
        this.name = string;
        this.clock = abstractClock;
        SimStrings.setStrings("localization/CommonStrings");
        this.helpManager = new HelpManager();
    }

    public AbstractClock getClock() {
        return this.clock;
    }

    public void setApparatusPanel(ApparatusPanel apparatusPanel) {
        this.apparatusPanel = apparatusPanel;
        if (this.helpManager != null) {
            this.helpManager.setComponent(apparatusPanel);
        } else {
            this.helpManager = new HelpManager(apparatusPanel);
        }
    }

    public ApparatusPanel getApparatusPanel() {
        return this.apparatusPanel;
    }

    public void setModel(BaseModel baseModel) {
        this.model = baseModel;
    }

    public JPanel getControlPanel() {
        return this.controlPanel;
    }

    public JPanel getMonitorPanel() {
        return this.monitorPanel;
    }

    public String getName() {
        return this.name;
    }

    public void activate(PhetApplication phetApplication) {
        if (!this.moduleIsWellFormed()) {
            throw new RuntimeException("Module missing important data, module=" + this);
        }
        phetApplication.getPhetFrame().getBasicPhetPanel().setControlPanel(this.getControlPanel());
        phetApplication.getPhetFrame().getBasicPhetPanel().setMonitorPanel(this.getMonitorPanel());
        phetApplication.addClockTickListener(this);
    }

    public void deactivate(PhetApplication phetApplication) {
        phetApplication.removeClockTickListener(this);
    }

    public boolean moduleIsWellFormed() {
        boolean bl = true;
        bl &= this.getModel() != null;
        return bl &= this.getApparatusPanel() != null;
    }

    public String toString() {
        return "name=" + this.name + ", model=" + this.model + ", apparatusPanel=" + this.apparatusPanel + ", controlPanel=" + this.controlPanel + ", monitorPanel=" + this.monitorPanel;
    }

    public boolean hasHelp() {
        return this.helpManager.getNumGraphics() > 0;
    }

    public void setHelpEnabled(boolean bl) {
        this.helpManager.setHelpEnabled(this.apparatusPanel, bl);
    }

    public void showMegaHelp() {
    }

    public boolean hasMegaHelp() {
        return false;
    }

    public void updateGraphics(ClockTickEvent clockTickEvent) {
    }

    public void clockTicked(ClockTickEvent clockTickEvent) {
        this.getApparatusPanel().handleUserInput();
        this.model.clockTicked(clockTickEvent);
        this.updateGraphics(clockTickEvent);
        this.getApparatusPanel().paint();
    }

    public BaseModel getModel() {
        return this.model;
    }
}

