/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_movingman.application;

import edu.colorado.phet.common_movingman.application.Module;
import edu.colorado.phet.common_movingman.application.ModuleManager;
import edu.colorado.phet.common_movingman.application.ModuleObserver;
import edu.colorado.phet.common_movingman.model.clock.AbstractClock;
import edu.colorado.phet.common_movingman.model.clock.ClockTickListener;
import edu.colorado.phet.common_movingman.util.DebugMenu;
import edu.colorado.phet.common_movingman.view.ApparatusPanel;
import edu.colorado.phet.common_movingman.view.ApparatusPanel2;
import edu.colorado.phet.common_movingman.view.PhetFrame;
import edu.colorado.phet.common_movingman.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common_movingman.view.util.FrameSetup;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class PhetApplication {
    private static PhetApplication s_instance = null;
    private PhetFrame phetFrame;
    private ModuleManager moduleManager;
    private String title;
    private Module initialModule;
    private AbstractClock clock;
    private String description;
    private String version;
    private boolean useClockControlPanel;

    public static PhetApplication instance() {
        return s_instance;
    }

    public PhetApplication(String[] stringArray, String string, String string2, String string3, AbstractClock abstractClock, boolean bl, FrameSetup frameSetup) {
        s_instance = this;
        this.moduleManager = new ModuleManager(this);
        this.title = string;
        this.clock = abstractClock;
        this.description = string2;
        this.version = string3;
        this.useClockControlPanel = bl;
        if (frameSetup != null) {
            this.setFrameSetup(frameSetup);
        }
        this.parseArgs(stringArray);
    }

    protected void parseArgs(String[] stringArray) {
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.equals("-d")) continue;
            this.phetFrame.addMenu(new DebugMenu(this));
        }
    }

    public void startApplication() {
        if (this.initialModule == null) {
            throw new RuntimeException("Initial module not specified.");
        }
        this.phetFrame.addWindowFocusListener(new WindowAdapter(){

            public void windowGainedFocus(WindowEvent windowEvent) {
                for (int i = 0; i < PhetApplication.this.moduleManager.numModules(); ++i) {
                    Module module = PhetApplication.this.moduleManager.moduleAt(i);
                    ApparatusPanel apparatusPanel = module.getApparatusPanel();
                    if (!(apparatusPanel instanceof ApparatusPanel2)) continue;
                    ApparatusPanel2 apparatusPanel2 = (ApparatusPanel2)apparatusPanel;
                    apparatusPanel2.setReferenceSize();
                }
                PhetApplication.this.phetFrame.removeWindowFocusListener(this);
            }
        });
        this.moduleManager.setActiveModule(this.initialModule);
        this.clock.start();
        this.phetFrame.setVisible(true);
    }

    public void setFrameSetup(FrameSetup frameSetup) {
        this.phetFrame = new PhetFrame(this, this.title, this.clock, frameSetup, this.useClockControlPanel, this.moduleManager, this.description, this.version);
        PhetJComponent.init(this.phetFrame);
    }

    public PhetFrame getPhetFrame() {
        return this.phetFrame;
    }

    public AbstractClock getClock() {
        return this.clock;
    }

    public void addClockTickListener(ClockTickListener clockTickListener) {
        this.clock.addClockTickListener(clockTickListener);
    }

    public void removeClockTickListener(ClockTickListener clockTickListener) {
        this.clock.removeClockTickListener(clockTickListener);
    }

    public void setModules(Module[] moduleArray) {
        while (this.moduleManager.numModules() > 0) {
            Module module = this.moduleManager.moduleAt(0);
            this.moduleManager.removeModule(module);
        }
        this.phetFrame.setModules(moduleArray);
        this.moduleManager.addAllModules(moduleArray);
        this.phetFrame.pack();
        this.setInitialModule(moduleArray[0]);
    }

    public void setInitialModule(Module module) {
        this.initialModule = module;
    }

    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    public Module moduleAt(int n) {
        return this.moduleManager.moduleAt(n);
    }

    public void setActiveModule(int n) {
        this.moduleManager.setActiveModule(n);
    }

    public void addModuleObserver(ModuleObserver moduleObserver) {
        this.moduleManager.addModuleObserver(moduleObserver);
    }

    public int indexOf(Module module) {
        return this.moduleManager.indexOf(module);
    }
}

