/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_movingman.model.clock;

import edu.colorado.phet.common_movingman.model.clock.AbstractClock;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class SwingTimerClock
extends AbstractClock {
    private Timer timer;
    private long lastTickTime;
    private DelayStrategy delayStrategy;

    public SwingTimerClock(double d, int n, boolean bl) {
        super(d, n, bl);
        this.timer = new Timer(n, new Ticker());
        this.delayStrategy = new DynamicDelay(n);
    }

    public void doStart() {
        this.lastTickTime = System.currentTimeMillis();
        this.timer.start();
    }

    protected void doPause() {
        this.timer.stop();
    }

    protected void doUnpause() {
        this.lastTickTime = System.currentTimeMillis();
        this.timer.restart();
    }

    private class Ticker
    implements ActionListener {
        private Ticker() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SwingTimerClock.this.isRunning()) {
                long l = System.currentTimeMillis();
                long l2 = l - SwingTimerClock.this.lastTickTime;
                int n = SwingTimerClock.this.delayStrategy.getDelay(l2);
                SwingTimerClock.this.timer.setDelay(n);
                SwingTimerClock.this.lastTickTime = l;
                if (SwingTimerClock.this.isRunning()) {
                    SwingTimerClock.this.clockTicked(SwingTimerClock.this.getSimulationTime(l2));
                }
            }
        }
    }

    private static class DynamicDelay
    implements DelayStrategy {
        private int delay;
        private long lastRequestedDelay;
        private int min;

        public DynamicDelay(int n) {
            this(n, 5);
        }

        public DynamicDelay(int n, int n2) {
            this.delay = n;
            this.min = n2;
        }

        public int getDelay(long l) {
            long l2 = l - this.lastRequestedDelay;
            long l3 = (long)this.delay - l2;
            int n = Math.min(this.delay, Math.max((int)l3, this.min));
            this.lastRequestedDelay = n;
            return n;
        }
    }

    private static interface DelayStrategy {
        public int getDelay(long var1);
    }
}

