/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_movingman.util;

import edu.colorado.phet.common_movingman.application.Module;
import edu.colorado.phet.common_movingman.application.ModuleManager;
import edu.colorado.phet.common_movingman.application.PhetApplication;
import edu.colorado.phet.common_movingman.model.clock.AbstractClock;
import edu.colorado.phet.common_movingman.model.clock.ClockTickEvent;
import edu.colorado.phet.common_movingman.model.clock.ClockTickListener;
import edu.colorado.phet.common_movingman.view.ApparatusPanel;
import edu.colorado.phet.common_movingman.view.ApparatusPanel2;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_movingman.view.util.LineGrid;
import edu.colorado.phet.common_movingman.view.util.MouseTracker;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DebugMenu
extends JMenu {
    private HashMap appPanelsToGrids = new HashMap();
    private PhetApplication app;

    public DebugMenu(PhetApplication phetApplication) {
        super("Debug");
        this.app = phetApplication;
        this.setMnemonic('D');
        this.add(new GridMenuItem());
        this.add(new MouseTrackerMenuItem());
        this.add(new FrameRateMenuItem());
        OffscreenBufferMenuItem offscreenBufferMenuItem = new OffscreenBufferMenuItem("OffscreenBuffer", true);
        OffscreenBufferMenuItem offscreenBufferMenuItem2 = new OffscreenBufferMenuItem("Paint directly to screen.", false);
        OffscreenBufferDirtyItem offscreenBufferDirtyItem = new OffscreenBufferDirtyItem();
        DisjointPaintMenuItem disjointPaintMenuItem = new DisjointPaintMenuItem();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(offscreenBufferMenuItem);
        buttonGroup.add(offscreenBufferMenuItem2);
        buttonGroup.add(offscreenBufferDirtyItem);
        buttonGroup.add(disjointPaintMenuItem);
        this.addSeparator();
        this.add(offscreenBufferMenuItem);
        this.add(offscreenBufferMenuItem2);
        this.add(offscreenBufferDirtyItem);
        this.add(disjointPaintMenuItem);
        this.addSeparator();
        this.add(new ShortCircuitRectangles());
    }

    private ApparatusPanel getApparatusPanel() {
        ApparatusPanel apparatusPanel = this.app.getModuleManager().getActiveModule().getApparatusPanel();
        return apparatusPanel;
    }

    static /* synthetic */ ApparatusPanel access$100(DebugMenu debugMenu) {
        return debugMenu.getApparatusPanel();
    }

    static /* synthetic */ HashMap access$200(DebugMenu debugMenu) {
        return debugMenu.appPanelsToGrids;
    }

    public class ShortCircuitRectangles
    extends JCheckBoxMenuItem {
        public ShortCircuitRectangles() {
            super("Skip Rectangle Computation", PhetGraphic.SKIP_RECTANGLE_COMPUTATION);
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ ShortCircuitRectangles this$1;
                {
                    this.this$1 = shortCircuitRectangles;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    PhetGraphic.SKIP_RECTANGLE_COMPUTATION = this.this$1.isSelected();
                }
            });
        }
    }

    public class DisjointPaintMenuItem
    extends JRadioButtonMenuItem {
        public DisjointPaintMenuItem() {
            super("Paint Direct/Disjoint");
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ DisjointPaintMenuItem this$1;
                {
                    this.this$1 = disjointPaintMenuItem;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < PhetApplication.instance().getModuleManager().numModules(); ++i) {
                        ApparatusPanel apparatusPanel = PhetApplication.instance().getModuleManager().moduleAt(i).getApparatusPanel();
                        if (!(apparatusPanel instanceof ApparatusPanel2)) continue;
                        ((ApparatusPanel2)apparatusPanel).setPaintStrategyDisjoint();
                    }
                }
            });
        }
    }

    public class OffscreenBufferDirtyItem
    extends JRadioButtonMenuItem {
        public OffscreenBufferDirtyItem() {
            super("OffscreenBuffer-(Dirty Regions Only)");
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ OffscreenBufferDirtyItem this$1;
                {
                    this.this$1 = offscreenBufferDirtyItem;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < PhetApplication.instance().getModuleManager().numModules(); ++i) {
                        ApparatusPanel apparatusPanel = PhetApplication.instance().getModuleManager().moduleAt(i).getApparatusPanel();
                        if (!(apparatusPanel instanceof ApparatusPanel2)) continue;
                        ((ApparatusPanel2)apparatusPanel).setUseOffscreenBufferDirtyRegion();
                    }
                }
            });
        }
    }

    private class OffscreenBufferMenuItem
    extends JRadioButtonMenuItem {
        private boolean useOffscreenBuffer;

        public OffscreenBufferMenuItem(String string, boolean bl) {
            super(string);
            this.useOffscreenBuffer = bl;
            this.addActionListener(new ActionListener(this, bl){
                private final /* synthetic */ boolean val$useOffscreenBuffer;
                private final /* synthetic */ OffscreenBufferMenuItem this$1;
                {
                    this.this$1 = offscreenBufferMenuItem;
                    this.val$useOffscreenBuffer = bl;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    PhetApplication phetApplication = PhetApplication.instance();
                    ModuleManager moduleManager = phetApplication.getModuleManager();
                    for (int i = 0; i < moduleManager.numModules(); ++i) {
                        Module module = moduleManager.moduleAt(i);
                        ApparatusPanel apparatusPanel = module.getApparatusPanel();
                        if (!(apparatusPanel instanceof ApparatusPanel2)) continue;
                        ApparatusPanel2 apparatusPanel2 = (ApparatusPanel2)apparatusPanel;
                        apparatusPanel2.setUseOffscreenBuffer(this.val$useOffscreenBuffer);
                        apparatusPanel2.revalidate();
                        apparatusPanel2.repaint(apparatusPanel2.getBounds());
                    }
                }
            });
        }
    }

    private class FrameRateMenuItem
    extends JCheckBoxMenuItem {
        private JDialog frameRateDlg;

        public FrameRateMenuItem() {
            super("Show frame rate");
            this.setMnemonic('f');
            this.frameRateDlg = new JDialog(DebugMenu.this.app.getPhetFrame(), "Frame Rate", false);
            JTextArea jTextArea = new JTextArea(10, 5);
            this.frameRateDlg.getContentPane().add(new JScrollPane(jTextArea, 22, 31));
            this.frameRateDlg.setUndecorated(true);
            this.frameRateDlg.getRootPane().setWindowDecorationStyle(2);
            this.frameRateDlg.pack();
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ FrameRateMenuItem this$1;
                {
                    this.this$1 = frameRateMenuItem;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    FrameRateMenuItem.access$600(this.this$1).setVisible(this.this$1.isSelected());
                }
            });
            this.startRecording(DebugMenu.this.app.getClock(), jTextArea);
        }

        void startRecording(AbstractClock abstractClock, JTextArea jTextArea) {
            abstractClock.addClockTickListener(new ClockTickListener(this, jTextArea){
                int frameCnt;
                long lastTickTime;
                long averagingTime;
                private final /* synthetic */ JTextArea val$textArea;
                private final /* synthetic */ FrameRateMenuItem this$1;
                {
                    this.this$1 = frameRateMenuItem;
                    this.val$textArea = jTextArea;
                    this.frameCnt = 0;
                    this.lastTickTime = System.currentTimeMillis();
                    this.averagingTime = 1000L;
                }

                public void clockTicked(ClockTickEvent clockTickEvent) {
                    ++this.frameCnt;
                    long l = System.currentTimeMillis();
                    if (l - this.lastTickTime > this.averagingTime) {
                        double d = (long)(this.frameCnt * 1000) / (l - this.lastTickTime);
                        this.lastTickTime = l;
                        this.frameCnt = 0;
                        this.val$textArea.append("    " + Double.toString(d) + "\n");
                    }
                }
            });
        }

        static /* synthetic */ JDialog access$600(FrameRateMenuItem frameRateMenuItem) {
            return frameRateMenuItem.frameRateDlg;
        }
    }

    private class MouseTrackerMenuItem
    extends JCheckBoxMenuItem {
        private HashMap appPanelToTracker;

        public MouseTrackerMenuItem() {
            super("Mouse tracker ");
            this.appPanelToTracker = new HashMap();
            this.setMnemonic('M');
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ MouseTrackerMenuItem this$1;
                {
                    this.this$1 = mouseTrackerMenuItem;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ApparatusPanel apparatusPanel = DebugMenu.access$100(MouseTrackerMenuItem.access$400(this.this$1));
                    if (apparatusPanel instanceof ApparatusPanel2) {
                        ApparatusPanel2 apparatusPanel2 = (ApparatusPanel2)apparatusPanel;
                        if (this.this$1.isSelected()) {
                            MouseTracker mouseTracker = new MouseTracker(apparatusPanel2);
                            apparatusPanel.addGraphic(mouseTracker, Double.MAX_VALUE);
                            MouseTrackerMenuItem.access$500(this.this$1).put(apparatusPanel2, mouseTracker);
                        } else {
                            MouseTracker mouseTracker = (MouseTracker)MouseTrackerMenuItem.access$500(this.this$1).get(apparatusPanel);
                            apparatusPanel.removeGraphic(mouseTracker);
                            MouseTrackerMenuItem.access$500(this.this$1).remove(apparatusPanel);
                        }
                    }
                }
            });
        }

        static /* synthetic */ DebugMenu access$400(MouseTrackerMenuItem mouseTrackerMenuItem) {
            return mouseTrackerMenuItem.DebugMenu.this;
        }

        static /* synthetic */ HashMap access$500(MouseTrackerMenuItem mouseTrackerMenuItem) {
            return mouseTrackerMenuItem.appPanelToTracker;
        }
    }

    private class GridMenuItem
    extends JCheckBoxMenuItem {
        public GridMenuItem() {
            super("Grid");
            this.setMnemonic('G');
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ GridMenuItem this$1;
                {
                    this.this$1 = gridMenuItem;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ApparatusPanel apparatusPanel = DebugMenu.access$100(GridMenuItem.access$000(this.this$1));
                    if (apparatusPanel instanceof ApparatusPanel2) {
                        ApparatusPanel2 apparatusPanel2 = (ApparatusPanel2)apparatusPanel;
                        if (this.this$1.isSelected()) {
                            LineGrid lineGrid = new LineGrid(apparatusPanel2, 100, 100, new Color(0, 128, 0));
                            DebugMenu.access$200(GridMenuItem.access$000(this.this$1)).put(apparatusPanel2, lineGrid);
                            apparatusPanel2.addGraphic(lineGrid);
                            apparatusPanel.repaint();
                        } else {
                            LineGrid lineGrid = (LineGrid)DebugMenu.access$200(GridMenuItem.access$000(this.this$1)).get(apparatusPanel2);
                            apparatusPanel2.removeGraphic(lineGrid);
                            DebugMenu.access$200(GridMenuItem.access$000(this.this$1)).remove(apparatusPanel2);
                            apparatusPanel2.repaint();
                        }
                    } else {
                        JOptionPane.showMessageDialog(DebugMenu.access$300(GridMenuItem.access$000(this.this$1)).getPhetFrame(), "<html>This option only applies to modules<br>that use ApparatusPanel2</html>");
                    }
                }
            });
        }

        static /* synthetic */ DebugMenu access$000(GridMenuItem gridMenuItem) {
            return gridMenuItem.DebugMenu.this;
        }
    }
}

