/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_movingman.view;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_movingman.model.clock.AbstractClock;
import edu.colorado.phet.common_movingman.model.clock.ClockStateEvent;
import edu.colorado.phet.common_movingman.model.clock.ClockStateListener;
import edu.colorado.phet.common_movingman.view.util.ImageLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ClockControlPanel
extends JPanel
implements ClockStateListener {
    private JButton play;
    private JButton pause;
    private JButton step;
    private AbstractClock clock;

    public ClockControlPanel(final AbstractClock abstractClock) throws IOException {
        this.clock = abstractClock;
        abstractClock.addClockStateListener(this);
        if (abstractClock == null) {
            throw new RuntimeException("Cannot have a control panel for a null clock.");
        }
        ImageLoader imageLoader = new ImageLoader();
        String string = "images/icons/java/media/";
        BufferedImage bufferedImage = imageLoader.loadImage(string + "Play24.gif");
        BufferedImage bufferedImage2 = imageLoader.loadImage(string + "Pause24.gif");
        BufferedImage bufferedImage3 = imageLoader.loadImage(string + "StepForward24.gif");
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        ImageIcon imageIcon2 = new ImageIcon(bufferedImage2);
        ImageIcon imageIcon3 = new ImageIcon(bufferedImage3);
        this.play = new JButton(SimStrings.get("Common.ClockControlPanel.Play"), imageIcon);
        this.pause = new JButton(SimStrings.get("Common.ClockControlPanel.Pause"), imageIcon2);
        this.step = new JButton(SimStrings.get("Common.ClockControlPanel.Step"), imageIcon3);
        this.step.setEnabled(false);
        this.play.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                abstractClock.setPaused(false);
                ClockControlPanel.this.play.setEnabled(false);
                ClockControlPanel.this.pause.setEnabled(true);
                ClockControlPanel.this.step.setEnabled(false);
            }
        });
        this.pause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                abstractClock.setPaused(true);
                ClockControlPanel.this.play.setEnabled(true);
                ClockControlPanel.this.pause.setEnabled(false);
                ClockControlPanel.this.step.setEnabled(true);
            }
        });
        this.step.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                abstractClock.tickOnce();
            }
        });
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.play);
        jPanel.add(this.pause);
        jPanel.add(this.step);
        this.add((Component)jPanel, "Center");
        this.play.setEnabled(false);
        this.pause.setEnabled(true);
    }

    public void stateChanged(ClockStateEvent clockStateEvent) {
        boolean bl = clockStateEvent.getIsPaused();
        this.play.setEnabled(bl);
        this.pause.setEnabled(!bl);
        this.step.setEnabled(bl);
    }
}

