/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_movingman.view.components.menu;

import edu.colorado.phet.common.phetcommon.application.PhetAboutDialog;
import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_movingman.application.ModuleEvent;
import edu.colorado.phet.common_movingman.application.ModuleManager;
import edu.colorado.phet.common_movingman.application.ModuleObserver;
import edu.colorado.phet.common_movingman.application.PhetApplication;
import edu.colorado.phet.common_movingman.view.PhetFrame;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class HelpMenu
extends JMenu
implements ModuleObserver {
    private JMenuItem onscreenHelp;
    private PhetFrame frame;

    public HelpMenu(final ModuleManager moduleManager, String string, String string2, String string3, final PhetFrame phetFrame) {
        super(SimStrings.get("Common.HelpMenu.Title"));
        this.frame = phetFrame;
        this.setMnemonic(SimStrings.get("Common.HelpMenu.TitleMnemonic").charAt(0));
        moduleManager.addModuleObserver(this);
        this.onscreenHelp = new JCheckBoxMenuItem(SimStrings.get("Common.HelpMenu.Help"));
        this.onscreenHelp.setMnemonic(SimStrings.get("Common.HelpMenu.HelpMnemonic").charAt(0));
        this.onscreenHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                moduleManager.getActiveModule().setHelpEnabled(HelpMenu.this.onscreenHelp.isSelected());
            }
        });
        this.onscreenHelp.setEnabled(moduleManager.getActiveModule() != null && moduleManager.getActiveModule().hasHelp());
        this.add(this.onscreenHelp);
        final JMenuItem jMenuItem = new JMenuItem(SimStrings.get("Common.HelpMenu.MegaHelp"));
        jMenuItem.setMnemonic(SimStrings.get("Common.HelpMenu.MegaHelpMnemonic").charAt(0));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (moduleManager.getActiveModule().hasMegaHelp()) {
                    moduleManager.getActiveModule().showMegaHelp();
                } else {
                    JOptionPane.showMessageDialog(PhetApplication.instance().getPhetFrame(), "No MegaHelp available for this module.");
                }
            }
        });
        moduleManager.addModuleObserver(new ModuleObserver(){

            public void moduleAdded(ModuleEvent moduleEvent) {
            }

            public void activeModuleChanged(ModuleEvent moduleEvent) {
                jMenuItem.setEnabled(moduleEvent.getModule().hasMegaHelp());
            }

            public void moduleRemoved(ModuleEvent moduleEvent) {
            }
        });
        jMenuItem.setEnabled(moduleManager.getActiveModule() != null && moduleManager.getActiveModule().hasMegaHelp());
        this.add(jMenuItem);
        this.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem(SimStrings.get("Common.HelpMenu.About"));
        jMenuItem2.setMnemonic(SimStrings.get("Common.HelpMenu.AboutMnemonic").charAt(0));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new PhetAboutDialog((Frame)phetFrame, "moving-man").show();
            }
        });
        this.add(jMenuItem2);
    }

    public void moduleAdded(ModuleEvent moduleEvent) {
    }

    public void activeModuleChanged(ModuleEvent moduleEvent) {
        this.onscreenHelp.setEnabled(moduleEvent.getModule() != null && moduleEvent.getModule().hasHelp());
    }

    public void moduleRemoved(ModuleEvent moduleEvent) {
    }
}

