/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_movingman.view.graphics.transforms;

import edu.colorado.phet.common_movingman.view.graphics.transforms.CompositeTransformListener;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ModelViewTransform2D {
    private Rectangle2D.Double modelBounds;
    private Rectangle viewBounds;
    private CompositeTransformListener listeners = new CompositeTransformListener();
    private boolean forwardTransformDirty = true;
    private AffineTransform forwardTransform;
    private boolean backTransformDirty = true;
    private AffineTransform backTransform;
    private boolean invertY;

    public ModelViewTransform2D(Rectangle2D rectangle2D, Rectangle rectangle) {
        this(rectangle2D, rectangle, true);
    }

    public ModelViewTransform2D(Rectangle2D rectangle2D, Rectangle rectangle, boolean bl) {
        this.setModelBounds(rectangle2D);
        this.setViewBounds(rectangle);
        this.invertY = bl;
    }

    private static Point toPoint(Point2D point2D) {
        if (point2D instanceof Point) {
            return (Point)point2D;
        }
        return new Point((int)point2D.getX(), (int)point2D.getY());
    }

    public Point modelToView(Point2D point2D) {
        this.fixForwardTransform();
        Point2D point2D2 = this.forwardTransform.transform(point2D, null);
        return ModelViewTransform2D.toPoint(point2D2);
    }

    private void fixForwardTransform() {
        if (this.forwardTransformDirty) {
            this.forwardTransform = this.createForwardTransform();
            this.forwardTransformDirty = false;
        }
    }

    protected AffineTransform createForwardTransform() {
        if (this.invertY) {
            return ModelViewTransform2D.createTXInvertY(this.viewBounds, this.modelBounds);
        }
        return ModelViewTransform2D.createTX(this.viewBounds, this.modelBounds);
    }

    public int modelToViewX(double d) {
        return this.modelToView((Point2D)new Point2D.Double((double)d, (double)0.0)).x;
    }

    public int modelToViewY(double d) {
        return this.modelToView((Point2D)new Point2D.Double((double)0.0, (double)d)).y;
    }

    public static AffineTransform createTX(Rectangle rectangle, Rectangle2D.Double double_) {
        double d = (double)rectangle.width / double_.width;
        double d2 = (double)rectangle.x - d * double_.x;
        double d3 = (double)rectangle.height / double_.height;
        double d4 = (double)rectangle.y - d3 * double_.y;
        return new AffineTransform(d, 0.0, 0.0, d3, d2, d4);
    }

    public static AffineTransform createTXInvertY(Rectangle rectangle, Rectangle2D.Double double_) {
        double d = (double)rectangle.width / double_.width;
        double d2 = (double)(-rectangle.height) / double_.height;
        double d3 = (double)rectangle.x - d * double_.x;
        double d4 = (double)rectangle.y + (double)rectangle.height / double_.height * (double_.y + double_.height);
        return new AffineTransform(d, 0.0, 0.0, d2, d3, d4);
    }

    public Point2D viewToModel(int n, int n2) {
        return this.viewToModel(new Point(n, n2));
    }

    public Point2D viewToModel(Point point) {
        this.fixBackTransform();
        return this.backTransform.transform(point, null);
    }

    private void fixBackTransform() {
        if (this.backTransformDirty) {
            this.backTransform = this.createBackTransform();
            this.backTransformDirty = false;
        }
    }

    private AffineTransform createBackTransform() {
        this.fixForwardTransform();
        try {
            return this.forwardTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new RuntimeException(noninvertibleTransformException);
        }
    }

    public double viewToModelY(int n) {
        return this.viewToModel(0, n).getY();
    }

    public double viewToModelX(int n) {
        return this.viewToModel(n, 0).getX();
    }

    public Rectangle2D.Double getModelBounds() {
        return this.modelBounds;
    }

    public void setModelBounds(Rectangle2D rectangle2D) {
        if (rectangle2D.getWidth() <= 0.0) {
            throw new RuntimeException("Model Width <= 0");
        }
        if (rectangle2D.getHeight() <= 0.0) {
            throw new RuntimeException("Model height<= 0");
        }
        this.modelBounds = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        this.forwardTransformDirty = true;
        this.backTransformDirty = true;
        this.listeners.transformChanged(this);
    }

    public void setViewBounds(Rectangle rectangle) {
        if (rectangle.getWidth() <= 0.0) {
            throw new RuntimeException("View Bounds width must be positive.");
        }
        if (rectangle.getHeight() <= 0.0) {
            throw new RuntimeException("View Bounds height must be positive.");
        }
        this.forwardTransformDirty = true;
        this.backTransformDirty = true;
        this.viewBounds = rectangle;
        this.listeners.transformChanged(this);
    }

    public String toString() {
        return "modelBounds=" + this.modelBounds.toString() + ", viewBounds=" + this.viewBounds;
    }
}

