/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_movingman.view.help;

import edu.colorado.phet.common_movingman.view.graphics.shapes.Arrow;
import edu.colorado.phet.common_movingman.view.help.HelpTarget;
import edu.colorado.phet.common_movingman.view.help.HelpTargetListener;
import edu.colorado.phet.common_movingman.view.help.PhetGraphicTarget;
import edu.colorado.phet.common_movingman.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.ShadowHTMLGraphic;
import edu.colorado.phet.common_movingman.view.util.RectangleUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class HelpItem3
extends CompositePhetGraphic
implements HelpTargetListener {
    private ShadowHTMLGraphic shadowHTMLGraphic;
    private PhetShapeGraphic textBackground;
    private HelpTarget helpTarget;
    private int arrowDX;
    private int arrowDY;
    private String text;
    private Color arrowColor = new Color(200, 50, 75, 200);
    private Color arrowBorderColor = new Color(40, 10, 40, 210);
    private Color textColor = new Color(50, 75, 240);
    private Color shadowColor = new Color(0, 0, 30, 128);
    private Color backgroundColor = new Color(220, 200, 140, 225);
    private Color borderColor = new Color(110, 100, 70, 210);
    private int arrowHeadSize = 10;
    private int tailWidth = 5;
    private Stroke textBorderStroke = new BasicStroke(1.0f, 1, 1);
    private Stroke arrowBorderStroke = new BasicStroke(1.0f, 1, 1);
    private PhetShapeGraphic arrowGraphic;
    private boolean helpEnabled = false;
    private int attachX;
    private int attachY;

    public HelpItem3(Component component, PhetGraphic phetGraphic, int n, int n2, String string) {
        this(component, HelpItem3.toTarget(phetGraphic, n, n2), n, n2, string);
    }

    private static HelpTarget toTarget(PhetGraphic phetGraphic, int n, int n2) {
        if (n < 0) {
            return new PhetGraphicTarget.Right(phetGraphic);
        }
        if (n > 0) {
            return new PhetGraphicTarget.Left(phetGraphic);
        }
        if (n2 < 0) {
            return new PhetGraphicTarget.Bottom(phetGraphic);
        }
        return new PhetGraphicTarget.Top(phetGraphic);
    }

    public HelpItem3(Component component, HelpTarget helpTarget, int n, int n2, String string) {
        super(component);
        this.helpTarget = helpTarget;
        this.arrowDX = n;
        this.arrowDY = n2;
        this.text = string;
        Font font = new Font("Lucida Sans", 0, 18);
        this.shadowHTMLGraphic = new ShadowHTMLGraphic(component, string, font, this.textColor, 1, 1, this.shadowColor);
        Rectangle rectangle = this.shadowHTMLGraphic.getBounds();
        Rectangle rectangle2 = RectangleUtils.expand(rectangle, 2, 2);
        this.textBackground = new PhetShapeGraphic(component, rectangle2, this.backgroundColor, this.textBorderStroke, this.borderColor);
        this.addGraphic(this.textBackground);
        this.addGraphic(this.shadowHTMLGraphic);
        this.arrowGraphic = this.createArrow(n, n2);
        this.attachArrow();
        this.addGraphic(this.arrowGraphic, -1.0);
        helpTarget.addListener(this);
        this.setIgnoreMouse(true);
        this.targetLocationChanged();
    }

    private void attachArrow() {
        int n = 0;
        int n2 = 0;
        if (this.arrowDX == 0) {
            n = this.textBackground.getWidth() / 2;
        } else if (this.arrowDX > 0) {
            n = this.textBackground.getWidth();
        }
        if (this.arrowDY == 0) {
            n2 = this.textBackground.getHeight() / 2;
        } else if (this.arrowDY > 0) {
            n2 = this.textBackground.getHeight();
        }
        this.attachX = n;
        this.attachY = n2;
        this.arrowGraphic.setLocation(n, n2);
    }

    private PhetShapeGraphic createArrow(double d, double d2) {
        Arrow arrow = new Arrow(new Point2D.Double(), new Point2D.Double(d, d2), this.arrowHeadSize, this.arrowHeadSize, this.tailWidth);
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(this.getComponent(), arrow.getShape(), this.arrowColor, this.arrowBorderStroke, this.arrowBorderColor);
        return phetShapeGraphic;
    }

    public boolean isHelpEnabled() {
        return this.helpEnabled;
    }

    public void setHelpEnabled(boolean bl) {
        this.helpEnabled = bl;
        this.targetVisibilityChanged();
    }

    public void targetVisibilityChanged() {
        this.setVisible(this.helpTarget.isVisible() && this.isHelpEnabled());
    }

    public void targetLocationChanged() {
        Point point = new Point(this.helpTarget.getLocation());
        point.x -= this.arrowDX + this.attachX;
        point.y -= this.arrowDY + this.attachY;
        this.setLocation(point);
    }
}

