/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_movingman.view.help;

import edu.colorado.phet.common_movingman.view.help.HelpTarget;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetGraphicListener;
import edu.colorado.phet.common_movingman.view.util.RectangleUtils;
import java.awt.Point;

public class PhetGraphicTarget
extends HelpTarget {
    private PhetGraphic target;

    public PhetGraphicTarget(PhetGraphic phetGraphic) {
        this.target = phetGraphic;
        phetGraphic.addPhetGraphicListener(new PhetGraphicListener(){

            public void phetGraphicChanged(PhetGraphic phetGraphic) {
                PhetGraphicTarget.this.notifyLocationChanged();
            }

            public void phetGraphicVisibilityChanged(PhetGraphic phetGraphic) {
                PhetGraphicTarget.this.notifyVisibilityChanged();
            }
        });
    }

    public boolean isVisible() {
        return this.target.isVisible();
    }

    public Point getLocation() {
        return RectangleUtils.getCenter(this.target.getBounds());
    }

    public PhetGraphic getTarget() {
        return this.target;
    }

    public static class Top
    extends PhetGraphicTarget {
        public Top(PhetGraphic phetGraphic) {
            super(phetGraphic);
        }

        public Point getLocation() {
            return RectangleUtils.getTopCenter(this.getTarget().getBounds());
        }
    }

    public static class Bottom
    extends PhetGraphicTarget {
        public Bottom(PhetGraphic phetGraphic) {
            super(phetGraphic);
        }

        public Point getLocation() {
            return RectangleUtils.getBottomCenter(this.getTarget().getBounds());
        }
    }

    public static class Right
    extends PhetGraphicTarget {
        public Right(PhetGraphic phetGraphic) {
            super(phetGraphic);
        }

        public Point getLocation() {
            return RectangleUtils.getRightCenter(this.getTarget().getBounds());
        }
    }

    public static class Left
    extends PhetGraphicTarget {
        public Left(PhetGraphic phetGraphic) {
            super(phetGraphic);
        }

        public Point getLocation() {
            return RectangleUtils.getLeftCenter(this.getTarget().getBounds());
        }
    }
}

