/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_movingman.view.phetcomponents;

import edu.colorado.phet.common_movingman.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetGraphics2D;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.event.MouseInputAdapter;

public class PhetJComponent
extends PhetGraphic {
    private static JWindow offscreen;
    private static boolean inited;
    private static JPanel offscreenContentPane;
    private JComponent component;
    private boolean topLevel;
    private BufferedImage image;
    private MouseInputAdapter mouseListener;
    private KeyListener keyHandler;
    private static PhetJComponentRepaintManager repaintManagerPhet;

    public static PhetGraphic newInstance(Component component, JComponent jComponent) {
        return PhetJComponent.newInstance(component, jComponent, true);
    }

    private static PhetGraphic newInstance(Component component, JComponent jComponent, boolean bl) {
        Object object;
        if (!inited) {
            PhetJComponent.init(null);
        }
        if (bl) {
            offscreen.getContentPane().add(jComponent);
        }
        offscreen.getContentPane().validate();
        offscreen.getContentPane().doLayout();
        Dimension dimension = jComponent.getPreferredSize();
        if (bl) {
            jComponent.reshape(jComponent.getX(), jComponent.getY(), dimension.width, dimension.height);
        } else {
            object = jComponent.getParent();
            ((Container)object).doLayout();
        }
        PhetJComponent.doNotifyAll(jComponent);
        if (jComponent.getComponentCount() > 0) {
            object = new GraphicLayerSet();
            Component[] componentArray = jComponent.getComponents();
            PhetJComponent.validateSuperTree(jComponent);
            ((GraphicLayerSet)object).addGraphic(new PhetJComponent(component, jComponent, bl));
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof JComponent)) {
                    System.out.println("children[i] = " + componentArray[i].getClass());
                    continue;
                }
                JComponent jComponent2 = (JComponent)componentArray[i];
                Point point = jComponent2.getLocation();
                PhetGraphic phetGraphic = PhetJComponent.newInstance(component, jComponent2, false);
                ((GraphicLayerSet)object).addGraphic(phetGraphic);
                phetGraphic.setLocation(point.x - jComponent.getX(), point.y - jComponent.getY());
            }
            return object;
        }
        return new PhetJComponent(component, jComponent, bl);
    }

    public static void init(Window window) {
        if (inited) {
            throw new RuntimeException("Multiple inits.");
        }
        RepaintManager.setCurrentManager(repaintManagerPhet);
        offscreen = new JWindow(window){

            public void invalidate() {
            }

            public void paint(Graphics graphics) {
            }
        };
        offscreen.setSize(0, 0);
        offscreen.setVisible(true);
        offscreenContentPane.setOpaque(false);
        offscreen.setContentPane(offscreenContentPane);
        inited = true;
    }

    private static void validateSuperTree(Component component) {
        component.invalidate();
        component.validate();
        component.doLayout();
        Container container = component.getParent();
        if (container != null) {
            PhetJComponent.validateSuperTree(container);
        }
    }

    private static void doNotifyAll(Component component) {
        component.addNotify();
        if (component instanceof Container) {
            Container container = (Container)component;
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                PhetJComponent.doNotifyAll(componentArray[i]);
            }
        }
    }

    protected PhetJComponent(Component component, final JComponent jComponent, boolean bl) {
        super(component);
        this.component = jComponent;
        this.topLevel = bl;
        this.repaint();
        this.mouseListener = new MouseInputAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PhetJComponent.this.applyEvent(jComponent, mouseEvent, new MouseListenerMethod(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void invoke(MouseListener mouseListener, MouseEvent mouseEvent) {
                        mouseListener.mouseClicked(mouseEvent);
                    }
                }, PhetJComponent.this.toLocalFrame(mouseEvent.getPoint()));
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                PhetJComponent.this.applyEvent(jComponent, mouseEvent, new MouseMotionListenerMethod(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void invoke(MouseMotionListener mouseMotionListener, MouseEvent mouseEvent) {
                        mouseMotionListener.mouseDragged(mouseEvent);
                    }
                }, PhetJComponent.this.toLocalFrame(mouseEvent.getPoint()));
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                PhetJComponent.this.applyEvent(jComponent, mouseEvent, new MouseListenerMethod(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void invoke(MouseListener mouseListener, MouseEvent mouseEvent) {
                        mouseListener.mouseEntered(mouseEvent);
                    }
                }, PhetJComponent.this.toLocalFrame(mouseEvent.getPoint()));
            }

            public void mouseExited(MouseEvent mouseEvent) {
                PhetJComponent.this.applyEvent(jComponent, mouseEvent, new MouseListenerMethod(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void invoke(MouseListener mouseListener, MouseEvent mouseEvent) {
                        mouseListener.mouseExited(mouseEvent);
                    }
                }, PhetJComponent.this.toLocalFrame(mouseEvent.getPoint()));
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                PhetJComponent.this.applyEvent(jComponent, mouseEvent, new MouseMotionListenerMethod(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void invoke(MouseMotionListener mouseMotionListener, MouseEvent mouseEvent) {
                        mouseMotionListener.mouseMoved(mouseEvent);
                    }
                }, PhetJComponent.this.toLocalFrame(mouseEvent.getPoint()));
            }

            public void mousePressed(MouseEvent mouseEvent) {
                PhetJComponent.this.applyEvent(jComponent, mouseEvent, new MouseListenerMethod(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void invoke(MouseListener mouseListener, MouseEvent mouseEvent) {
                        mouseListener.mousePressed(mouseEvent);
                    }
                }, PhetJComponent.this.toLocalFrame(mouseEvent.getPoint()));
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                PhetJComponent.this.applyEvent(jComponent, mouseEvent, new MouseListenerMethod(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void invoke(MouseListener mouseListener, MouseEvent mouseEvent) {
                        mouseListener.mouseReleased(mouseEvent);
                    }
                }, PhetJComponent.this.toLocalFrame(mouseEvent.getPoint()));
            }
        };
        this.addMouseInputListener(this.mouseListener);
        this.keyHandler = new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                PhetJComponent.this.handleKeypress(keyEvent, new KeyMethod(this){
                    private final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void invoke(KeyListener keyListener, KeyEvent keyEvent) {
                        keyListener.keyPressed(keyEvent);
                    }
                });
            }

            public void keyReleased(KeyEvent keyEvent) {
                PhetJComponent.this.handleKeypress(keyEvent, new KeyMethod(this){
                    private final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void invoke(KeyListener keyListener, KeyEvent keyEvent) {
                        keyListener.keyReleased(keyEvent);
                    }
                });
            }

            public void keyTyped(KeyEvent keyEvent) {
                PhetJComponent.this.handleKeypress(keyEvent, new KeyMethod(this){
                    private final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void invoke(KeyListener keyListener, KeyEvent keyEvent) {
                        keyListener.keyTyped(keyEvent);
                    }
                });
            }
        };
        this.addKeyListener(this.keyHandler);
        jComponent.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                PhetJComponent.this.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                PhetJComponent.this.repaint();
            }
        });
        repaintManagerPhet.put(this);
    }

    private void handleKeypress(KeyEvent keyEvent, KeyMethod keyMethod) {
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        ActionListener actionListener = this.component.getActionForKeyStroke(keyStroke);
        ActionEvent actionEvent = new ActionEvent(this.component, keyEvent.getID(), keyEvent.getKeyChar() + "", keyEvent.getWhen(), keyEvent.getModifiers());
        if (actionListener != null) {
            actionListener.actionPerformed(actionEvent);
        }
        KeyListener[] keyListenerArray = this.component.getKeyListeners();
        KeyEvent keyEvent2 = new KeyEvent(this.component, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation());
        for (int i = 0; i < keyListenerArray.length; ++i) {
            KeyListener keyListener = keyListenerArray[i];
            keyMethod.invoke(keyListener, keyEvent2);
        }
    }

    private boolean applyEvent(JComponent jComponent, MouseEvent mouseEvent, MouseMethod mouseMethod, Point point) {
        MouseListener[] mouseListenerArray = jComponent.getMouseListeners();
        Point point2 = this.toLocalFrame(mouseEvent.getPoint());
        MouseEvent mouseEvent2 = new MouseEvent(jComponent, mouseEvent.getID(), System.currentTimeMillis(), mouseEvent.getModifiers(), point2.x, point2.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
        boolean bl = false;
        if (mouseMethod instanceof MouseListenerMethod) {
            MouseListenerMethod mouseListenerMethod = (MouseListenerMethod)mouseMethod;
            for (int i = 0; i < mouseListenerArray.length; ++i) {
                MouseListener mouseListener = mouseListenerArray[i];
                mouseListenerMethod.invoke(mouseListener, mouseEvent2);
                bl = true;
            }
        } else if (mouseMethod instanceof MouseMotionListenerMethod) {
            MouseMotionListenerMethod mouseMotionListenerMethod = (MouseMotionListenerMethod)mouseMethod;
            MouseMotionListener[] mouseMotionListenerArray = jComponent.getMouseMotionListeners();
            for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
                MouseMotionListener mouseMotionListener = mouseMotionListenerArray[i];
                mouseMotionListenerMethod.invoke(mouseMotionListener, mouseEvent2);
                bl = true;
            }
        } else {
            throw new RuntimeException("Illegal mouse handler class: " + mouseMethod);
        }
        if (bl) {
            this.redraw();
        }
        return bl;
    }

    private Point toLocalFrame(Point point) {
        AffineTransform affineTransform = this.getNetTransform();
        try {
            Point2D point2D = affineTransform.inverseTransform(point, null);
            return new Point((int)point2D.getX(), (int)point2D.getY());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
            throw new RuntimeException(noninvertibleTransformException);
        }
    }

    private void redraw() {
        Graphics2D graphics2D;
        Dimension dimension = this.component.getPreferredSize();
        if (!this.topLevel) {
            dimension = this.component.getSize();
        }
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        this.component.reshape(0, 0, dimension.width, dimension.height);
        if (this.image == null) {
            this.image = new BufferedImage(dimension.width, dimension.height, 2);
        } else if (this.image.getWidth() != dimension.width || this.image.getHeight() != dimension.height) {
            this.image = new BufferedImage(dimension.width, dimension.height, 2);
        } else {
            graphics2D = this.image.createGraphics();
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.setColor(this.component.getBackground());
            graphics2D.fill(new Rectangle(0, 0, this.image.getWidth(), this.image.getHeight()));
            graphics2D.setComposite(composite);
        }
        graphics2D = this.image.createGraphics();
        graphics2D = new PhetGraphics2D(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.component.paint(graphics2D);
        this.setBoundsDirty();
    }

    protected Rectangle determineBounds() {
        if (this.image == null) {
            return null;
        }
        return this.getNetTransform().createTransformedShape(new Rectangle(0, 0, this.image.getWidth(), this.image.getHeight())).getBounds();
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible()) {
            super.saveGraphicsState(graphics2D);
            RenderingHints renderingHints = super.getRenderingHints();
            if (renderingHints != null) {
                graphics2D.setRenderingHints(renderingHints);
            }
            if (this.component != null && this.image != null) {
                graphics2D.transform(this.getNetTransform());
                graphics2D.drawRenderedImage(this.image, new AffineTransform());
            }
            super.restoreGraphicsState();
        }
    }

    public void repaint() {
        this.redraw();
        super.repaint();
    }

    public JComponent getSourceComponent() {
        return this.component;
    }

    static {
        inited = false;
        offscreenContentPane = new JPanel(null){

            public void invalidate() {
            }

            protected void paintComponent(Graphics graphics) {
            }
        };
        repaintManagerPhet = new PhetJComponentRepaintManager();
    }

    public static class PhetJComponentRepaintManager
    extends RepaintManager {
        private Hashtable table = new Hashtable();

        public synchronized void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
            super.addDirtyRegion(jComponent, n, n2, n3, n4);
            if (this.table.containsKey(jComponent)) {
                PhetJComponent phetJComponent = (PhetJComponent)this.table.get(jComponent);
                if (jComponent.getComponentCount() == 0 && new Exception().getStackTrace().length < 75) {
                    phetJComponent.repaint();
                }
            }
        }

        public void put(PhetJComponent phetJComponent) {
            this.table.put(phetJComponent.component, phetJComponent);
        }
    }

    private static interface MouseMotionListenerMethod
    extends MouseMethod {
        public void invoke(MouseMotionListener var1, MouseEvent var2);
    }

    private static interface MouseListenerMethod
    extends MouseMethod {
        public void invoke(MouseListener var1, MouseEvent var2);
    }

    private static interface MouseMethod {
    }

    private static interface KeyMethod {
        public void invoke(KeyListener var1, KeyEvent var2);
    }
}

