/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_movingman.view.phetgraphics;

import edu.colorado.phet.common_movingman.model.clock.AbstractClock;
import edu.colorado.phet.common_movingman.model.clock.ClockTickEvent;
import edu.colorado.phet.common_movingman.model.clock.ClockTickListener;
import edu.colorado.phet.common_movingman.view.ApparatusPanel;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetGraphic;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;

public class RepaintDebugGraphic
extends PhetGraphic
implements ClockTickListener {
    private int r = 255;
    private int g = 255;
    private int b = 255;
    private int alpha = 255;
    private ApparatusPanel panel;
    private AbstractClock clock;
    private boolean active = false;

    public RepaintDebugGraphic(ApparatusPanel apparatusPanel, AbstractClock abstractClock) {
        this(apparatusPanel, abstractClock, 128);
    }

    public RepaintDebugGraphic(ApparatusPanel apparatusPanel, AbstractClock abstractClock, int n) {
        super(apparatusPanel);
        this.panel = apparatusPanel;
        this.clock = abstractClock;
        this.setActive(true);
        this.setIgnoreMouse(true);
        this.setTransparency(n);
    }

    public void setTransparency(int n) {
        this.alpha = n;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible()) {
            super.saveGraphicsState(graphics2D);
            super.updateGraphicsState(graphics2D);
            graphics2D.setColor(new Color(this.r, this.g, this.b, this.alpha));
            graphics2D.setTransform(new AffineTransform());
            graphics2D.fillRect(0, 0, this.panel.getWidth(), this.panel.getHeight());
            super.restoreGraphicsState();
        }
    }

    public void clockTicked(ClockTickEvent clockTickEvent) {
        this.r = (this.r - 1 + 255) % 255;
        this.g = (this.g - 2 + 255) % 255;
        this.b = (this.b - 3 + 255) % 255;
    }

    public void setActive(boolean bl) {
        if (this.active == bl) {
            return;
        }
        this.active = bl;
        if (bl) {
            this.clock.addClockTickListener(this);
        } else {
            this.clock.removeClockTickListener(this);
        }
    }

    protected Rectangle determineBounds() {
        return new Rectangle(0, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    public boolean isActive() {
        return this.active;
    }

    public static void enable(final ApparatusPanel apparatusPanel, AbstractClock abstractClock) {
        final RepaintDebugGraphic repaintDebugGraphic = new RepaintDebugGraphic(apparatusPanel, abstractClock);
        apparatusPanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                apparatusPanel.requestFocus();
            }
        });
        repaintDebugGraphic.setVisible(false);
        apparatusPanel.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    boolean bl = !repaintDebugGraphic.isActive();
                    repaintDebugGraphic.setActive(bl);
                    repaintDebugGraphic.setVisible(bl);
                    if (bl) {
                        apparatusPanel.addGraphic(repaintDebugGraphic, Double.POSITIVE_INFINITY);
                    } else {
                        apparatusPanel.removeGraphic(repaintDebugGraphic);
                    }
                    apparatusPanel.paintImmediately(0, 0, apparatusPanel.getWidth(), apparatusPanel.getHeight());
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        repaintDebugGraphic.setActive(false);
        repaintDebugGraphic.setVisible(false);
    }
}

