/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_movingman.view.util;

import edu.colorado.phet.common_movingman.view.ApparatusPanel2;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_movingman.view.util.GraphicsState;
import edu.colorado.phet.common_movingman.view.util.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;

public class LineGrid
extends PhetGraphic
implements ApparatusPanel2.ChangeListener {
    private static Stroke defaultStroke = new BasicStroke(1.0f);
    private int dx;
    private int dy;
    private Dimension canvasSize;
    private Paint color;
    private Stroke stroke;
    private double alpha = 1.0;
    private ApparatusPanel2 appPanel;

    public LineGrid(ApparatusPanel2 apparatusPanel2, int n, int n2, Color color) {
        this(apparatusPanel2, n, n2, color, defaultStroke);
    }

    public LineGrid(ApparatusPanel2 apparatusPanel2, int n, int n2, Color color, Stroke stroke) {
        super(apparatusPanel2);
        this.appPanel = apparatusPanel2;
        this.dx = n;
        this.dy = n2;
        this.color = color;
        this.stroke = stroke;
        this.setCanvasSize(apparatusPanel2.getCanvasSize());
        this.setIgnoreMouse(true);
    }

    public void setCanvasSize(Dimension dimension) {
        this.canvasSize = dimension;
    }

    protected Rectangle determineBounds() {
        this.setCanvasSize(this.appPanel.getCanvasSize());
        return new Rectangle(this.canvasSize);
    }

    public void paint(Graphics2D graphics2D) {
        GraphicsState graphicsState = new GraphicsState(graphics2D);
        graphics2D.setPaint(this.color);
        graphics2D.setStroke(this.stroke);
        GraphicsUtil.setAlpha(graphics2D, this.alpha);
        int n = this.dx;
        while ((double)n < this.canvasSize.getWidth()) {
            graphics2D.drawLine(n, 0, n, (int)this.canvasSize.getHeight());
            int n2 = this.dy;
            while ((double)n2 < this.canvasSize.getHeight()) {
                graphics2D.drawLine(0, n2, (int)this.canvasSize.getWidth(), n2);
                n2 += this.dy;
            }
            n += this.dx;
        }
        graphicsState.restoreGraphics();
    }

    public void canvasSizeChanged(ApparatusPanel2.ChangeEvent changeEvent) {
        this.setCanvasSize(changeEvent.getCanvasSize());
    }
}

