/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_movingman.view.util;

import edu.colorado.phet.common_movingman.view.ApparatusPanel2;
import edu.colorado.phet.common_movingman.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.common_movingman.view.util.GraphicsState;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public class MouseTracker
extends CompositePhetGraphic
implements MouseMotionListener,
ApparatusPanel2.ChangeListener {
    private PhetTextGraphic readout;
    private Point mouseLocation = new Point();
    private Dimension canvasSize = new Dimension();
    private Stroke stroke = new BasicStroke(1.0f);

    public MouseTracker(ApparatusPanel2 apparatusPanel2) {
        super(apparatusPanel2);
        apparatusPanel2.addMouseMotionListener(this);
        apparatusPanel2.addChangeListener(this);
        this.readout = new PhetTextGraphic(apparatusPanel2, new Font("Lucida sans", 0, 10), "", Color.black);
        this.addGraphic(this.readout);
        this.addGraphic(new CrosshairGraphic(apparatusPanel2));
        this.setCanvasSize(apparatusPanel2.getCanvasSize());
    }

    protected Rectangle determineBounds() {
        return new Rectangle(this.canvasSize);
    }

    public void setCanvasSize(Dimension dimension) {
        this.canvasSize = dimension;
    }

    public void paint(Graphics2D graphics2D) {
        GraphicsState graphicsState = new GraphicsState(graphics2D);
        Rectangle rectangle = new Rectangle(this.readout.getBounds());
        rectangle.setBounds(rectangle.x - 2, rectangle.y - 2, rectangle.width + 3, rectangle.height + 2);
        graphics2D.setColor(Color.white);
        graphics2D.fill(rectangle);
        graphics2D.setColor(Color.black);
        graphics2D.draw(rectangle);
        super.paint(graphics2D);
        graphicsState.restoreGraphics();
    }

    public void canvasSizeChanged(ApparatusPanel2.ChangeEvent changeEvent) {
        this.setCanvasSize(changeEvent.getCanvasSize());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseLocation.setLocation(mouseEvent.getPoint());
        this.readout.setLocation(this.mouseLocation.x + 8, this.mouseLocation.y - 16);
        this.readout.setText("[" + this.mouseLocation.x + ":" + this.mouseLocation.y + "]");
        this.setBoundsDirty();
        this.repaint();
    }

    private class CrosshairGraphic
    extends PhetGraphic {
        protected CrosshairGraphic(Component component) {
            super(component);
        }

        protected Rectangle determineBounds() {
            return new Rectangle(MouseTracker.this.canvasSize);
        }

        public void paint(Graphics2D graphics2D) {
            GraphicsState graphicsState = new GraphicsState(graphics2D);
            graphics2D.setStroke(MouseTracker.this.stroke);
            graphics2D.setColor(Color.red);
            graphics2D.drawLine(0, (int)MouseTracker.this.mouseLocation.getY(), ((MouseTracker)MouseTracker.this).canvasSize.width, (int)MouseTracker.this.mouseLocation.getY());
            graphics2D.drawLine((int)MouseTracker.this.mouseLocation.getX(), 0, (int)MouseTracker.this.mouseLocation.getX(), ((MouseTracker)MouseTracker.this).canvasSize.height);
            graphicsState.restoreGraphics();
        }
    }
}

