/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_movingman.application.ApplicationModel;
import edu.colorado.phet.common_movingman.application.Module;
import edu.colorado.phet.common_movingman.application.PhetApplication;
import edu.colorado.phet.common_movingman.model.clock.SwingTimerClock;
import edu.colorado.phet.common_movingman.view.PhetFrame;
import edu.colorado.phet.common_movingman.view.PhetLookAndFeel;
import edu.colorado.phet.common_movingman.view.phetgraphics.RepaintDebugGraphic;
import edu.colorado.phet.common_movingman.view.util.FrameSetup;
import edu.colorado.phet.movingman.MovingManModule;
import java.awt.Insets;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.SwingUtilities;

public class MovingManApplication {
    private static boolean addJEP = true;
    private MovingManModule module;

    public static void main(final String[] stringArray) throws Exception {
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                try {
                    new MovingManApplication(stringArray);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
    }

    public MovingManApplication(String[] stringArray) throws IOException {
        PhetLookAndFeel phetLookAndFeel = new PhetLookAndFeel();
        phetLookAndFeel.setInsets(new Insets(1, 1, 1, 1));
        phetLookAndFeel.apply();
        PhetLookAndFeel.setLookAndFeel();
        SimStrings.getInstance().addStrings("moving-man/localization/moving-man-strings");
        SwingTimerClock swingTimerClock = new SwingTimerClock(1.0, 30, false);
        FrameSetup.MaxExtent maxExtent = new FrameSetup.MaxExtent(new FrameSetup.CenteredWithSize(800, 800));
        String string = PhetApplicationConfig.getVersion("moving-man").formatForTitleBar();
        ApplicationModel applicationModel = new ApplicationModel(SimStrings.get("moving-man.name") + " (" + string + ")", SimStrings.get("moving-man.description"), string, maxExtent);
        applicationModel.setName("movingman");
        PhetApplication phetApplication = new PhetApplication(stringArray, applicationModel.getWindowTitle(), applicationModel.getDescription(), applicationModel.getVersion(), swingTimerClock, false, maxExtent);
        PhetFrame phetFrame = phetApplication.getPhetFrame();
        this.module = new MovingManModule(swingTimerClock);
        phetApplication.setModules(new Module[]{this.module});
        this.module.setFrame(phetFrame);
        if (this.module.getControlPanel() != null) {
            // empty if block
        }
        if (addJEP) {
            MovingManModule.addMiscMenu(this.module);
        }
        phetApplication.startApplication();
        this.module.getTimeModel().getRecordMode().initialize();
        this.module.setInited(true);
        this.module.relayout();
        this.module.setSmoothingSmooth();
        RepaintDebugGraphic.enable(this.module.getApparatusPanel(), swingTimerClock);
        if (Arrays.asList(stringArray).contains("-position")) {
            this.getModule().minimizeGraphsExceptPosition();
        }
    }

    public MovingManModule getModule() {
        return this.module;
    }
}

