/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_movingman.view.components.VerticalLayoutPanel;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.PlaybackPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MovingManControlPanel
extends JPanel {
    private MovingManModule module;
    private JPanel controllerContainer;
    private PlaybackPanel playbackPanel;
    private JButton reset;

    public MovingManControlPanel(final MovingManModule movingManModule) throws IOException {
        this.module = movingManModule;
        Dimension dimension = new Dimension(200, 400);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        this.setLayout(new BorderLayout());
        this.controllerContainer = new JPanel();
        this.controllerContainer.setPreferredSize(new Dimension(200, 200));
        this.controllerContainer.setSize(new Dimension(200, 200));
        this.add((Component)this.controllerContainer, "Center");
        this.playbackPanel = new PlaybackPanel(movingManModule);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        new Thread(new Runnable(){

            public void run() {
                try {
                    while (movingManModule.getFrame() == null || !movingManModule.getFrame().isVisible()) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                movingManModule.getFrame().setExtendedState(2);
                movingManModule.getFrame().setExtendedState(6);
            }
        }).start();
        ImageIcon imageIcon = new ImageIcon(this.getClass().getClassLoader().getResource("moving-man/images/Phet-Flatirons-logo-3-small.jpg"));
        JLabel jLabel = new JLabel(imageIcon);
        verticalLayoutPanel.add(jLabel);
        final JCheckBox jCheckBox = new JCheckBox(SimStrings.get("controls.reverse-x-axis"), false);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = movingManModule.confirmClear();
                if (bl) {
                    movingManModule.setRightDirPositive(!jCheckBox.isSelected());
                }
            }
        });
        verticalLayoutPanel.add(jCheckBox);
        this.reset = new JButton(SimStrings.get("controls.reset"));
        this.reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                movingManModule.reset();
                MovingManControlPanel.this.reset.setEnabled(false);
            }
        });
        this.reset.setEnabled(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.reset);
        verticalLayoutPanel.setFill(0);
        verticalLayoutPanel.setAnchor(17);
        verticalLayoutPanel.setInsets(new Insets(4, 4, 4, 4));
        verticalLayoutPanel.add(jPanel2);
        jPanel.add((Component)verticalLayoutPanel, "North");
    }

    public JComponent getPlaybackPanel() {
        return this.playbackPanel;
    }
}

