/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_movingman.application.Module;
import edu.colorado.phet.common_movingman.application.PhetApplication;
import edu.colorado.phet.common_movingman.model.BaseModel;
import edu.colorado.phet.common_movingman.model.clock.AbstractClock;
import edu.colorado.phet.common_movingman.view.ApparatusPanel;
import edu.colorado.phet.common_movingman.view.ContentPanel;
import edu.colorado.phet.common_movingman.view.PhetFrame;
import edu.colorado.phet.common_movingman.view.help.HelpPanel;
import edu.colorado.phet.common_movingman.view.util.ImageLoader;
import edu.colorado.phet.common_movingman.view.util.SwingUtils;
import edu.colorado.phet.movingman.MMHelpSuite;
import edu.colorado.phet.movingman.MovingManControlPanel;
import edu.colorado.phet.movingman.common.CircularBuffer;
import edu.colorado.phet.movingman.common.LinearTransform1d;
import edu.colorado.phet.movingman.misc.ExpressionFrame;
import edu.colorado.phet.movingman.model.DataSuite;
import edu.colorado.phet.movingman.model.MMTimer;
import edu.colorado.phet.movingman.model.Man;
import edu.colorado.phet.movingman.model.Mode;
import edu.colorado.phet.movingman.model.MovingManModel;
import edu.colorado.phet.movingman.model.MovingManTimeModel;
import edu.colorado.phet.movingman.model.TimeListener;
import edu.colorado.phet.movingman.plotdevice.PlotDevice;
import edu.colorado.phet.movingman.plotdevice.PlotDeviceListenerAdapter;
import edu.colorado.phet.movingman.plots.PlotSet;
import edu.colorado.phet.movingman.view.GoPauseClearPanel;
import edu.colorado.phet.movingman.view.ManGraphic;
import edu.colorado.phet.movingman.view.MovingManApparatusPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;

public class MovingManModule
extends Module {
    private PhetFrame frame;
    private MovingManModel movingManModel;
    private MovingManControlPanel movingManControlPanel;
    private MMHelpSuite helpSuite;
    private boolean initMediaPanel = false;
    private MovingManApparatusPanel movingManApparatusPanel;
    private boolean soundEnabled = true;
    private ArrayList listeners = new ArrayList();

    public MovingManModule(AbstractClock abstractClock) throws IOException {
        super(SimStrings.get("moving-man.name"), abstractClock);
        super.setModel(new BaseModel());
        this.movingManModel = new MovingManModel(this, abstractClock);
        this.movingManApparatusPanel = new MovingManApparatusPanel(this);
        this.helpSuite = new MMHelpSuite(this);
        this.helpSuite.init(this);
        super.setApparatusPanel(this.movingManApparatusPanel);
        this.movingManControlPanel = new MovingManControlPanel(this);
        this.getModel().addModelElement(this.movingManModel.getMainModelElement());
        this.getApparatusPanel().addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                MovingManModule.this.initMediaPanel();
                MovingManModule.this.relayout();
            }

            public void componentResized(ComponentEvent componentEvent) {
                MovingManModule.this.initMediaPanel();
                MovingManModule.this.relayout();
            }
        });
        abstractClock.addClockTickListener(this.getModel());
        this.movingManModel.fireReset();
        this.getVelocityPlot().addListener(new PlotDeviceListenerAdapter(){
            CircularBuffer circularBuffer = new CircularBuffer(20);

            public void sliderDragged(double d) {
                double d2 = MovingManModule.this.getVelocityPlot().getSliderValue();
                if (d2 == 0.0) {
                    MovingManModule.this.getMovingManApparatusPanel().getManGraphic().setVelocity(0.0);
                }
            }
        });
        this.getManGraphic().addListener(new ManGraphic.Listener(){

            public void manGraphicChanged() {
            }

            public void mouseReleased() {
                MovingManModule.this.getManGraphic().setVelocity(0.0);
            }
        });
        this.movingManModel.setRecordMode();
    }

    public void showMegaHelp() {
        this.showHelpImage("moving-man/images/megahelp.gif");
    }

    public void showHelpImage(String string) {
        final JFrame jFrame = new JFrame();
        try {
            BufferedImage bufferedImage = ImageLoader.loadBufferedImage(string);
            JLabel jLabel = new JLabel(new ImageIcon(bufferedImage));
            jFrame.setContentPane(jLabel);
            jFrame.pack();
            SwingUtils.centerWindowOnScreen(jFrame);
            jFrame.setVisible(true);
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                }
            });
            jFrame.setResizable(false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            iOException.printStackTrace(new PrintWriter(stringWriter));
            JOptionPane.showMessageDialog(this.getApparatusPanel(), stringWriter.getBuffer().toString(), SimStrings.get("controls.error-loading-help"), 0);
        }
    }

    public void setHelpEnabled(boolean bl) {
        super.setHelpEnabled(bl);
        this.helpSuite.setHelpEnabled(bl);
    }

    public void recordingFinished() {
        this.setPaused(true);
        this.getTimeModel().fireFinishedRecording();
    }

    public void firePlaybackFinished() {
        this.getTimeModel().firePlaybackFinished();
    }

    public MovingManTimeModel getTimeModel() {
        return this.movingManModel.getTimeModel();
    }

    public void setWiggleMeVisible(boolean bl) {
        this.getMovingManApparatusPanel().setWiggleMeVisible(bl);
    }

    public boolean isPaused() {
        return this.getTimeModel().isPaused();
    }

    public MovingManModel getMovingManModel() {
        return this.movingManModel;
    }

    public void addListener(TimeListener timeListener) {
        this.getTimeModel().addListener(timeListener);
    }

    public void setPaused(boolean bl) {
        this.getTimeModel().setPaused(bl);
        this.getPositionPlot().requestTypingFocus();
    }

    public void setSmoothingSmooth() {
        this.movingManModel.setSmoothingSmooth();
    }

    public void setSmoothingSharp() {
        this.movingManModel.setSmoothingSharp();
    }

    public void setRightDirPositive(boolean bl) {
        if (bl) {
            this.getManPositionTransform().setInput(-this.getMaxManPosition(), this.getMaxManPosition());
        } else {
            this.getManPositionTransform().setInput(this.getMaxManPosition(), -this.getMaxManPosition());
        }
        this.setManTransform(this.getManPositionTransform());
        this.getTimeModel().setRecordMode();
        this.reset();
        this.setPaused(true);
    }

    public boolean hasMegaHelp() {
        return true;
    }

    public void repaintBackground() {
        this.getMovingManApparatusPanel().repaintBackground();
    }

    public LinearTransform1d getManPositionTransform() {
        return this.movingManApparatusPanel.getManPositionTransform();
    }

    private void initMediaPanel() {
        if (this.initMediaPanel) {
            return;
        }
        JFrame jFrame = (JFrame)SwingUtilities.getWindowAncestor(this.getApparatusPanel());
        JPanel jPanel = (JPanel)jFrame.getContentPane();
        ContentPanel contentPanel = (ContentPanel)jPanel;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JComponent jComponent = this.movingManControlPanel.getPlaybackPanel();
        jPanel2.add((Component)jComponent, "Center");
        ImageIcon imageIcon = new ImageIcon(this.getClass().getClassLoader().getResource("moving-man/images/Phet-Flatirons-logo-3-small.jpg"));
        HelpPanel helpPanel = new HelpPanel(this);
        jPanel2.add((Component)helpPanel, "East");
        contentPanel.setAppControlPanel(jPanel2);
        this.initMediaPanel = true;
    }

    public ManGraphic getManGraphic() {
        return this.getMovingManApparatusPanel().getManGraphic();
    }

    public PlotSet getPlotSet() {
        return this.movingManApparatusPanel.getPlotSet();
    }

    public PlotDevice getPositionPlot() {
        return this.getPlotSet().getPositionPlot();
    }

    public PlotDevice getVelocityPlot() {
        return this.getPlotSet().getVelocityPlot();
    }

    public DataSuite getPosition() {
        return this.movingManModel.getPositionDataSuite();
    }

    public void setMode(Mode mode) {
        this.getTimeModel().setMode(mode);
        this.repaintBackground();
    }

    public void relayout() {
        this.getMovingManApparatusPanel().relayout();
        ApparatusPanel apparatusPanel = this.getApparatusPanel();
        if (((Component)apparatusPanel).getHeight() > 0 && ((Component)apparatusPanel).getWidth() > 0) {
            this.getApparatusPanel().repaint();
        }
    }

    public void activate(PhetApplication phetApplication) {
    }

    public void deactivate(PhetApplication phetApplication) {
    }

    void setFrame(PhetFrame phetFrame) {
        this.frame = phetFrame;
    }

    public Man getMan() {
        return this.movingManModel.getMan();
    }

    public MMTimer getRecordingTimer() {
        return this.getTimeModel().getRecordTimer();
    }

    public void setReplayTime(double d) {
        if (d < 0.0 || d > this.getTimeModel().getRecordTimer().getTime()) {
            return;
        }
        this.getTimeModel().getPlaybackTimer().setTime(d);
        this.movingManModel.setReplayTime(d);
    }

    public void rewind() {
        this.getTimeModel().rewind();
        this.getMan().reset();
    }

    public void setRecordMode() {
        this.enterTextBoxValues();
        this.getTimeModel().setRecordMode();
    }

    private void enterTextBoxValues() {
        this.getPlotSet().enterTextBoxValues();
    }

    public void startPlaybackMode(double d) {
        this.getTimeModel().startPlaybackMode(d);
    }

    public void setManTransform(LinearTransform1d linearTransform1d) {
        this.getMovingManApparatusPanel().setManTransform(linearTransform1d);
    }

    public void setSoundEnabled(boolean bl) {
        if (bl != this.soundEnabled) {
            this.soundEnabled = bl;
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener listener = (Listener)this.listeners.get(i);
                listener.soundOptionChanged(bl);
            }
        }
    }

    public boolean isSoundEnabled() {
        return this.soundEnabled;
    }

    public Man.Direction getDirection() {
        return this.getManGraphic().getDirection();
    }

    public void setReplayManDirection(double d) {
        this.getManGraphic().setDirection(d);
    }

    public boolean isSmoothingSmooth() {
        return this.movingManModel.isSmoothingSmooth();
    }

    public boolean isAtEndOfTime() {
        return this.movingManModel.getTimeModel().isAtEndOfTime();
    }

    public void requestEditInTextBox(GoPauseClearPanel goPauseClearPanel) {
        this.movingManApparatusPanel.requestEditInTextBox(goPauseClearPanel);
    }

    public void minimizeGraphsExceptPosition() {
        this.movingManApparatusPanel.minimizeGraphsExceptPosition();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void reset() {
        this.movingManModel.reset();
        this.movingManApparatusPanel.reset();
        this.notifyReset();
    }

    private void notifyReset() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.reset();
        }
    }

    public DataSuite getVelocityData() {
        return this.movingManModel.getVelocitySeries();
    }

    public DataSuite getAcceleration() {
        return this.movingManModel.getAccelerationDataSuite();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public double getMaxTime() {
        return this.movingManModel.getMaxTime();
    }

    public double getMaxManPosition() {
        return this.movingManModel.getMaxManPosition();
    }

    public MMTimer getPlaybackTimer() {
        return this.getTimeModel().getPlaybackTimer();
    }

    public boolean isRecordMode() {
        return this.getTimeModel().isRecordMode();
    }

    void setInited(boolean bl) {
        this.getMovingManApparatusPanel().setInited(bl);
    }

    public MovingManApparatusPanel getMovingManApparatusPanel() {
        return this.movingManApparatusPanel;
    }

    static void addMiscMenu(final MovingManModule movingManModule) {
        JFrame jFrame = movingManModule.getFrame();
        JMenu jMenu = new JMenu(SimStrings.get("controls.special-features"));
        jMenu.setMnemonic(SimStrings.get("controls.special-features.mnemonic").charAt(0));
        JMenuItem jMenuItem = new JMenuItem(SimStrings.get("expressions.title"));
        jMenu.add(jMenuItem);
        final ExpressionFrame expressionFrame = new ExpressionFrame((Frame)jFrame, movingManModule);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                expressionFrame.setVisible(true);
            }
        });
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(SimStrings.get("controls.reverse-x-axis"), false);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = movingManModule.confirmClear();
                if (bl) {
                    movingManModule.setRightDirPositive(!jCheckBoxMenuItem.isSelected());
                }
            }
        });
        jMenu.add(jCheckBoxMenuItem);
        jMenu.addSeparator();
        movingManModule.addBoundaryConditionButtons(jMenu);
        jMenu.addSeparator();
        movingManModule.addTimeScaleChooser(jMenu);
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem(SimStrings.get("options.model-options"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                movingManModule.getMovingManModel().showControls();
            }
        });
        jMenu.add(jMenuItem2);
        jFrame.getJMenuBar().add(jMenu);
    }

    private void addTimeScaleChooser(JMenu jMenu) {
        boolean bl = false;
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(SimStrings.get("options.real-time"), bl);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MovingManModule.this.setDynamicTime(jCheckBoxMenuItem.isSelected());
            }
        });
        jMenu.add(jCheckBoxMenuItem);
        this.setDynamicTime(bl);
    }

    private void setDynamicTime(boolean bl) {
        this.movingManModel.getTimeModel().setDynamicTime(bl);
        if (bl) {
            this.getClock().setTickConverter(new AbstractClock.RealTime());
        } else {
            this.getClock().setStaticTickConverter();
        }
    }

    private void addBoundaryConditionButtons(JMenu jMenu) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(SimStrings.get("options.walls"), true);
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(SimStrings.get("options.free-range"), false);
        jRadioButtonMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MovingManModule.this.setBoundaryConditionsOpen();
            }
        });
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MovingManModule.this.setBoundaryConditionsClosed();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        jMenu.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem2);
    }

    public void setBoundaryConditionsClosed() {
        this.movingManModel.setBoundaryConditionsClosed();
        this.movingManApparatusPanel.setBoundaryConditionsClosed();
    }

    public void setBoundaryConditionsOpen() {
        this.movingManModel.setBoundaryConditionsOpen();
        this.movingManApparatusPanel.setBoundaryConditionsOpen();
    }

    public void setShowAccelerationVector(boolean bl) {
        this.movingManApparatusPanel.setShowAccelerationVector(bl);
    }

    public void setShowVelocityVector(boolean bl) {
        this.movingManApparatusPanel.setShowVelocityVector(bl);
    }

    public void step(double d) {
        this.movingManModel.step(d);
        this.getPlotSet().updateSliders();
    }

    public void initialize() {
        this.movingManApparatusPanel.initialize();
    }

    public boolean confirmClear() {
        double d = this.getMovingManModel().getTimeModel().getRecordMode().getTimer().getTime();
        if (d == 0.0) {
            return true;
        }
        this.setPaused(true);
        int n = JOptionPane.showConfirmDialog(this.getApparatusPanel(), SimStrings.get("plot.confirm-clear"), SimStrings.get("plot.confirm-reset"), 1);
        return n == 0 || n == 0;
    }

    public void confirmAndApplyReset() {
        MovingManModule movingManModule = this;
        boolean bl = movingManModule.isPaused();
        movingManModule.setPaused(true);
        boolean bl2 = this.confirmClear();
        if (bl2) {
            movingManModule.reset();
        } else {
            movingManModule.setPaused(bl);
        }
    }

    public static interface Listener {
        public void reset();

        public void soundOptionChanged(boolean var1);
    }
}

