/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_movingman.view.util.ImageLoader;
import edu.colorado.phet.movingman.ArrowPanel;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.model.TimeListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class PlaybackPanel
extends JPanel {
    private JButton play;
    private JButton pause;
    private JButton rewind;
    private JButton slowMotion;
    private JButton clear;
    private MovingManModule module;

    public PlaybackPanel(final MovingManModule movingManModule) throws IOException {
        this.module = movingManModule;
        ImageIcon imageIcon = new ImageIcon(new ImageLoader().loadImage("moving-man/images/icons/java/media/Pause24.gif"));
        this.pause = new JButton(SimStrings.get("time.pause"), imageIcon);
        this.pause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                movingManModule.setPaused(true);
            }
        });
        ImageIcon imageIcon2 = new ImageIcon(new ImageLoader().loadImage("moving-man/images/icons/java/media/Play24.gif"));
        this.play = new JButton(SimStrings.get("time.playback"), imageIcon2);
        this.play.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                movingManModule.startPlaybackMode(1.0);
            }
        });
        ImageIcon imageIcon3 = new ImageIcon(new ImageLoader().loadImage("moving-man/images/icons/java/media/Rewind24.gif"));
        this.rewind = new JButton(SimStrings.get("time.rewind"), imageIcon3);
        this.rewind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                movingManModule.rewind();
                movingManModule.setPaused(true);
            }
        });
        ImageIcon imageIcon4 = new ImageIcon(new ImageLoader().loadImage("moving-man/images/icons/java/media/StepForward24.gif"));
        this.slowMotion = new JButton(SimStrings.get("time.slow-playback"), imageIcon4);
        this.slowMotion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                movingManModule.startPlaybackMode(0.4);
            }
        });
        this.clear = new JButton(SimStrings.get("time.clear"));
        this.clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                movingManModule.confirmAndApplyReset();
            }
        });
        this.add(this.play);
        this.add(this.slowMotion);
        this.add(this.pause);
        this.add(this.rewind);
        this.add(this.clear);
        ArrowPanel arrowPanel = new ArrowPanel(movingManModule);
        this.add(arrowPanel);
        final JCheckBox jCheckBox = new JCheckBox(SimStrings.get("options.sound"), true);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                movingManModule.setSoundEnabled(jCheckBox.isSelected());
            }
        });
        this.add(new JSeparator());
        this.add(jCheckBox);
        TimeListener timeListener = new TimeListener(){

            public void recordingStarted() {
                PlaybackPanel.this.setButtons(false, false, false, false);
            }

            public void recordingPaused() {
                PlaybackPanel.this.setButtons(true, true, false, true);
            }

            public void recordingFinished() {
                PlaybackPanel.this.setButtons(true, true, false, true);
            }

            public void playbackFinished() {
                PlaybackPanel.this.setButtons(false, false, false, true);
            }

            public void playbackStarted() {
                PlaybackPanel.this.setButtons(false, false, true, true);
            }

            public void playbackPaused() {
                PlaybackPanel.this.setButtons(true, true, false, true);
            }

            public void reset() {
                PlaybackPanel.this.setButtons(false, false, false, false);
            }

            public void rewind() {
                PlaybackPanel.this.setButtons(true, true, false, false);
            }
        };
        movingManModule.addListener(timeListener);
    }

    private void setButtons(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.play.setEnabled(bl);
        this.slowMotion.setEnabled(bl2);
        this.pause.setEnabled(bl3);
        this.rewind.setEnabled(bl4);
    }
}

