/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.common;

import edu.colorado.phet.common_movingman.math.AbstractVector2D;
import edu.colorado.phet.common_movingman.math.Vector2D;
import edu.colorado.phet.common_movingman.model.clock.AbstractClock;
import edu.colorado.phet.common_movingman.model.clock.ClockTickEvent;
import edu.colorado.phet.common_movingman.model.clock.ClockTickListener;
import edu.colorado.phet.common_movingman.view.graphics.shapes.Arrow;
import edu.colorado.phet.common_movingman.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.ShadowHTMLGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.Point2D;

public class Force1DWiggleMe
extends CompositePhetGraphic {
    private long t0 = System.currentTimeMillis();
    private double frequency = 2.5;
    private double amplitude = 30.0;
    private Vector2D.Double oscillationAxis;
    private Target target;
    private PhetShapeGraphic phetShapeGraphic;
    private ShadowHTMLGraphic textGraphic;
    private ClockTickListener tickListener;
    private AbstractClock clock;

    public Force1DWiggleMe(Component component, AbstractClock abstractClock, String string, Target target) {
        this(component, abstractClock, string, target, new Font("Lucida Sans", 1, 20), 1, 1);
    }

    public Force1DWiggleMe(Component component, AbstractClock abstractClock, String string, Target target, Font font, int n, int n2) {
        super(component);
        this.target = target;
        this.clock = abstractClock;
        this.oscillationAxis = new Vector2D.Double(0.0, 1.0);
        Color color = new Color(39, 27, 184);
        Color color2 = new Color(6, 0, 44);
        this.textGraphic = new ShadowHTMLGraphic(component, string, font, color, n, n2, color2);
        this.addGraphic(this.textGraphic);
        this.textGraphic.setLocation(0, 0);
        this.tickListener = new ClockTickListener(){

            public void clockTicked(ClockTickEvent clockTickEvent) {
                Force1DWiggleMe.this.tick();
            }
        };
        this.setVisible(true);
        Arrow arrow = new Arrow(new Point2D.Double(0.0, 0.0), new Point2D.Double(50.0, 0.0), 20.0, 20.0, 10.0);
        this.phetShapeGraphic = new PhetShapeGraphic(component, arrow.getShape(), Color.blue, new BasicStroke(2.0f), Color.black);
        this.addGraphic(this.phetShapeGraphic);
        this.setRegistrationPoint(this.getBounds().x, this.getBounds().y);
        this.tick();
        this.setIgnoreMouse(true);
        this.phetShapeGraphic.setLocation(this.textGraphic.getWidth() - this.phetShapeGraphic.getWidth() - 5, this.textGraphic.getHeight() + 5);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            if (!this.clock.containsClockTickListener(this.tickListener)) {
                this.clock.addClockTickListener(this.tickListener);
            }
        } else {
            while (this.clock.containsClockTickListener(this.tickListener)) {
                this.clock.removeClockTickListener(this.tickListener);
            }
        }
    }

    public void setArrow(double d, double d2) {
        Arrow arrow = new Arrow(new Point2D.Double(0.0, 0.0), new Point2D.Double(d, d2), 20.0, 20.0, 10.0);
        this.phetShapeGraphic.setShape(arrow.getShape());
    }

    private void tick() {
        if (this.isVisible() && this.getComponent().isShowing()) {
            double d = (double)(System.currentTimeMillis() - this.t0) / 1000.0;
            Point point = this.target.getLocation();
            Point point2 = this.getOscillationCenter(point);
            double d2 = Math.sin(this.frequency * d) * this.amplitude;
            AbstractVector2D abstractVector2D = this.oscillationAxis.getInstanceOfMagnitude(d2);
            Point2D point2D = abstractVector2D.getDestination(point2);
            this.setLocation((int)point2D.getX(), (int)point2D.getY());
        }
    }

    protected Point getOscillationCenter(Point point) {
        Point point2 = new Point(point.x - this.getWidth() - 5, point.y);
        return point2;
    }

    public static interface Target {
        public Point getLocation();
    }
}

