/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.common;

import edu.colorado.phet.common_movingman.view.graphics.shapes.Arrow;
import edu.colorado.phet.common_movingman.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.ShadowHTMLGraphic;
import edu.colorado.phet.common_movingman.view.util.RectangleUtils;
import edu.colorado.phet.movingman.common.RelativeLocationSetter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class HelpItem2
extends CompositePhetGraphic {
    private ShadowHTMLGraphic shadowHTMLGraphic;
    private PhetShapeGraphic textBackground;
    private String text;
    private Color arrowColor = new Color(200, 50, 75, 200);
    private Color arrowBorderColor = new Color(40, 10, 40, 210);
    private Color textColor = new Color(50, 75, 240);
    private Color shadowColor = new Color(0, 0, 30, 128);
    private Color backgroundColor = new Color(220, 200, 140, 225);
    private Color borderColor = new Color(110, 100, 70, 210);
    private int arrowHeadSize = 10;
    private int tailWidth = 5;
    private Stroke textBorderStroke = new BasicStroke(1.0f, 1, 1);
    private Stroke arrowBorderStroke = new BasicStroke(1.0f, 1, 1);
    private PhetGraphic target;

    public HelpItem2(Component component, String string) {
        super(component);
        this.text = string;
        Font font = new Font("Lucida Sans", 0, 18);
        this.shadowHTMLGraphic = new ShadowHTMLGraphic(component, string, font, this.textColor, 1, 1, this.shadowColor);
        Rectangle rectangle = this.shadowHTMLGraphic.getBounds();
        Rectangle rectangle2 = RectangleUtils.expand(rectangle, 2, 2);
        this.textBackground = new PhetShapeGraphic(component, rectangle2, this.backgroundColor, this.textBorderStroke, this.borderColor);
        this.addGraphic(this.textBackground);
        this.addGraphic(this.shadowHTMLGraphic);
        this.setIgnoreMouse(true);
    }

    public PhetShapeGraphic addArrow(double d, double d2) {
        Arrow arrow = new Arrow(new Point2D.Double(), new Point2D.Double(d, d2), this.arrowHeadSize, this.arrowHeadSize, this.tailWidth);
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(this.getComponent(), arrow.getShape(), this.arrowColor, this.arrowBorderStroke, this.arrowBorderColor);
        this.addGraphic(phetShapeGraphic);
        this.setBoundsDirty();
        this.autorepaint();
        return phetShapeGraphic;
    }

    public void addArrowPointingLeft(int n) {
        PhetShapeGraphic phetShapeGraphic = this.addArrow(-n, 0.0);
        new RelativeLocationSetter.Left().layout(this.textBackground, phetShapeGraphic);
    }

    public void pointLeftAt(RelativeLocationSetter.Target target, int n) {
        this.addArrowPointingLeft(n);
        RelativeLocationSetter.follow(target, new RelativeLocationSetter.MovablePhetGraphic(this), (RelativeLocationSetter)new RelativeLocationSetter.Right(1));
    }

    public void pointLeftAt(PhetGraphic phetGraphic, int n) {
        this.pointLeftAt(new RelativeLocationSetter.PhetGraphicTarget(phetGraphic), n);
        this.addArrowPointingLeft(n);
        RelativeLocationSetter.follow(phetGraphic, this, (RelativeLocationSetter)new RelativeLocationSetter.Right(1));
        this.target = phetGraphic;
    }
}

