/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.common;

import edu.colorado.phet.common_movingman.math.AbstractVector2D;
import edu.colorado.phet.common_movingman.model.ModelElement;
import edu.colorado.phet.common_movingman.view.graphics.shapes.Arrow;
import edu.colorado.phet.common_movingman.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetShadowTextGraphic;
import edu.colorado.phet.common_movingman.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common_movingman.view.util.RectangleUtils;
import edu.colorado.phet.movingman.MMFontManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Point2D;

public class WiggleMe
extends CompositePhetGraphic
implements ModelElement {
    private Sine sine;
    private double time = 0.0;
    private Point2D.Double current;
    private Font font = MMFontManager.getFontSet().getWiggleMeFont();
    private AbstractVector2D oscillationVector;
    private Point2D startPt;
    private PhetShadowTextGraphic textGraphic;
    private String text;
    private PhetShapeGraphic arrowGraphic;

    public WiggleMe(Component component, Point2D point2D, AbstractVector2D abstractVector2D, double d, double d2, String string) {
        super(component);
        this.setVisible(false);
        this.startPt = point2D;
        this.text = string;
        this.sine = new Sine(1.0, d2);
        this.oscillationVector = abstractVector2D.getInstanceOfMagnitude(d);
        this.current = new Point2D.Double(point2D.getX(), point2D.getY());
        this.arrowGraphic = new PhetShapeGraphic(component, new Area(), Color.black);
        this.textGraphic = new PhetShadowTextGraphic(this.getComponent(), this.font, string, Color.blue, 1, 1, Color.black);
        this.stepInTime(0.0);
        this.addGraphic(this.arrowGraphic);
        this.addGraphic(this.textGraphic);
        this.setVisible(true);
    }

    public void stepInTime(double d) {
        if (!this.isVisible()) {
            return;
        }
        this.time += d;
        double d2 = this.sine.valueAtTime(this.time);
        Point2D point2D = this.oscillationVector.getScaledInstance(d2).getDestination(this.startPt);
        this.current.setLocation(point2D);
        if (this.textGraphic != null) {
            Rectangle rectangle = this.textGraphic.getBounds();
            this.textGraphic.setLocation((int)point2D.getX(), (int)point2D.getY());
            Rectangle rectangle2 = this.textGraphic.getBounds();
            rectangle = RectangleUtils.expand(rectangle, 5, 5);
            rectangle2 = RectangleUtils.expand(rectangle2, 5, 5);
            Point point = RectangleUtils.getRightCenter(this.textGraphic.getBounds());
            Point2D.Double double_ = new Point2D.Double(((Point2D)point).getX() + 15.0, ((Point2D)point).getY() + 12.0);
            Arrow arrow = new Arrow(point, double_, 8.0, 8.0, 4.0, 100.0, false);
            this.arrowGraphic.setShape(arrow.getShape());
        }
        super.setBoundsDirty();
    }

    public void setCenter(Point point) {
        this.startPt = point;
    }

    public int getWidth() {
        return (int)this.textGraphic.getBounds().getWidth();
    }

    static class Sine {
        private double frequency;
        private double amplitude;
        private double phase = 0.0;

        public Sine(double d, double d2) {
            this.frequency = d2;
            this.amplitude = d;
        }

        public double valueAtTime(double d) {
            double d2 = 0.0;
            d2 = this.frequency != 0.0 ? Math.sin(this.frequency * d * Math.PI * 2.0 - this.phase) * this.amplitude : 0.0;
            return d2;
        }
    }
}

