/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.misc;

import bsh.EvalError;
import bsh.Interpreter;
import edu.colorado.phet.common.phetcommon.view.MultiStateButton;
import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_movingman.view.components.VerticalLayoutPanel;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.model.Mode;
import edu.colorado.phet.movingman.plots.TimePoint;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExpressionFrame
extends JDialog {
    private MovingManModule module;
    private EvaluationMode mode;

    public ExpressionFrame(Frame frame, final MovingManModule movingManModule) throws HeadlessException {
        super(frame, SimStrings.get("expressions.title"), false);
        this.module = movingManModule;
        this.mode = new EvaluationMode(movingManModule);
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        JLabel jLabel = new JLabel(SimStrings.get("expressions.description"));
        JPanel jPanel = new JPanel(new FlowLayout());
        String string = SimStrings.get("expressions.example");
        final JTextField jTextField = new JTextField(string, 15);
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionFrame.this.mode.setExpression(jTextField.getText());
            }
        });
        jTextField.setBackground(Color.white);
        jPanel.add(new JLabel(" " + SimStrings.get("expressions.range") + " = "));
        jPanel.add(jTextField);
        verticalLayoutPanel.add(jLabel);
        verticalLayoutPanel.add(jPanel);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionFrame.this.mode.setExpression(jTextField.getText());
                movingManModule.setMode(ExpressionFrame.this.mode);
                movingManModule.setPaused(false);
            }
        };
        String string2 = "go";
        String string3 = "pause";
        MultiStateButton multiStateButton = new MultiStateButton();
        multiStateButton.addMode(string2, SimStrings.get("plot.go"), null);
        multiStateButton.addMode(string3, SimStrings.get("plot.pause"), null);
        multiStateButton.addActionListener(string2, actionListener);
        multiStateButton.addActionListener(string3, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                movingManModule.setPaused(true);
            }
        });
        JButton jButton = new JButton(SimStrings.get("plot.go"));
        jButton.addActionListener(actionListener);
        JButton jButton2 = new JButton(SimStrings.get("expressions.control.reset"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                movingManModule.reset();
            }
        });
        verticalLayoutPanel.setAnchor(10);
        verticalLayoutPanel.setFill(0);
        verticalLayoutPanel.add(multiStateButton);
        verticalLayoutPanel.add(jButton2);
        JButton jButton3 = new JButton("Help and Examples");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionFrame.this.showInformation();
            }
        });
        verticalLayoutPanel.add(jButton3);
        this.setContentPane(verticalLayoutPanel);
        this.pack();
    }

    private void showInformation() {
        String string = "You can type mathematical expressions here\nas a function of time.  Then, by pressing 'Go', the Man will\ntrace out your function.\n\nMultiplication is written as '*' (implicit multiplication like 3t is not supported)\n\nExamples:\n3*t\nlog(t)\npow(t,2)\nsqrt(sin(t^2))\npow(t,2)-t+3\n";
        JOptionPane.showMessageDialog(this, string, "Java Expression Parser", 1);
    }

    private class EvaluationMode
    extends Mode {
        private MovingManModule module;
        private String expression;
        Interpreter interpreter;

        public EvaluationMode(MovingManModule movingManModule) {
            super(movingManModule, SimStrings.get("expressions.mode"), true);
            this.interpreter = new Interpreter();
            this.module = movingManModule;
        }

        public void initialize() {
            this.module.repaintBackground();
            this.module.setWiggleMeVisible(false);
        }

        public void stepInTime(double d) {
            Object object;
            String string = "(" + this.module.getRecordingTimer().getTime() + ")";
            String string2 = this.expression.replaceAll("cos", "Math.cos");
            string2 = string2.replaceAll("sin", "Math.sin");
            string2 = string2.replaceAll("pi", "Math.PI");
            string2 = string2.replaceAll("log", "Math.log");
            string2 = string2.replaceAll("pow", "Math.pow");
            double d2 = 0.0;
            try {
                object = this.interpreter.eval("t=" + string + "; y=" + string2);
                d2 = ((Number)object).doubleValue();
            }
            catch (EvalError evalError) {
                evalError.printStackTrace();
            }
            if (this.module.getRecordingTimer().getTime() >= this.module.getMaxTime()) {
                this.timeFinished();
                return;
            }
            d2 = Math.min(d2, this.module.getMaxManPosition());
            if ((d2 = Math.max(d2, -this.module.getMaxManPosition())) == this.module.getMaxManPosition()) {
                this.module.getMan().setVelocity(0.0);
            }
            if (d2 == -this.module.getMaxManPosition()) {
                this.module.getMan().setVelocity(0.0);
            }
            this.module.getRecordingTimer().stepInTime(d, this.module.getMaxTime());
            this.module.getMan().setPosition(d2);
            this.module.getPosition().addPoint(this.module.getMan().getPosition(), this.module.getRecordingTimer().getTime());
            this.module.getPosition().updateSmoothedSeries();
            object = this.module.getPosition().getDerivative(d);
            if (object != null) {
                this.module.getVelocityData().addPoint((TimePoint)object);
            }
            this.module.getVelocityData().updateSmoothedSeries();
            TimePoint timePoint = this.module.getVelocityData().getDerivative(d);
            if (timePoint != null) {
                this.module.getAcceleration().addPoint(timePoint);
            }
            this.module.getAcceleration().updateSmoothedSeries();
            if (this.module.getRecordingTimer().getTime() >= this.module.getMaxTime()) {
                this.timeFinished();
                return;
            }
        }

        private void timeFinished() {
        }

        private void setExpression(String string) {
            this.expression = string;
            System.out.println("expression = " + string);
        }
    }
}

