/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.model;

import edu.colorado.phet.movingman.plots.TimePoint;
import edu.colorado.phet.movingman.plots.TimeSeries;

public class DataSuite {
    private TimeSeries timeSeries = new TimeSeries();
    private TimeSeries smoothedSeries = new TimeSeries();
    private int numSmoothingPoints;

    public DataSuite(int n) {
        this.numSmoothingPoints = n;
    }

    public void updateSmoothedSeries() {
        int n = Math.min(this.numSmoothingPoints, this.timeSeries.size());
        if (n == 0) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.timeSeries.lastPointAt(i).getValue();
            d2 += this.timeSeries.lastPointAt(i).getTime();
        }
        double d3 = d / (double)n;
        double d4 = d2 / (double)n;
        if (Double.isNaN(d3)) {
            d3 = 0.0;
            throw new RuntimeException("NaN result for average.");
        }
        this.smoothedSeries.addPoint(d3, d4);
    }

    public TimeSeries getSmoothedDataSeries() {
        return this.smoothedSeries;
    }

    public TimePoint getDerivative(double d) {
        TimePoint timePoint = this.smoothedSeries.getLatestDerivative(d);
        return timePoint;
    }

    public void addPoint(double d, double d2) {
        this.timeSeries.addPoint(d, d2);
    }

    public int numSmoothedPoints() {
        return this.smoothedSeries.size();
    }

    public void reset() {
        this.timeSeries.reset();
        this.smoothedSeries.reset();
    }

    public void setNumSmoothingPoints(int n) {
        this.numSmoothingPoints = n;
    }

    public void addPoint(TimePoint timePoint) {
        this.timeSeries.addPoint(timePoint.getValue(), timePoint.getTime());
    }

    public TimeSeries getRawData() {
        return this.timeSeries;
    }
}

