/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.model;

import java.util.ArrayList;

public class MMTimer {
    private double time = 0.0;
    private String name;
    private ArrayList listeners = new ArrayList();

    public MMTimer(String string) {
        this.name = string;
    }

    public void stepInTime(double d, double d2) {
        double d3 = this.time;
        this.time += d;
        this.time = Math.min(this.time, d2);
        if (this.time != d3) {
            this.updateObservers();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void updateObservers() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.timeChanged();
        }
    }

    public String toString() {
        return "MMTimer, name=" + this.name;
    }

    public double getTime() {
        return this.time;
    }

    public void reset() {
        this.time = 0.0;
        this.updateObservers();
    }

    public void setTime(double d) {
        this.time = d;
        this.updateObservers();
    }

    public static interface Listener {
        public void timeChanged();
    }
}

