/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.model;

import java.util.ArrayList;

public class Man {
    private double x;
    private double x0;
    private boolean grabbed = false;
    private double velocity;
    private double acceleration;
    private double minX;
    private double maxX;
    private ArrayList listeners = new ArrayList();
    private boolean boundaryConditionsClosed = true;

    public Man(double d, double d2, double d3) {
        this.x0 = d;
        this.x = d;
        this.minX = d2;
        this.maxX = d3;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void setBoundaryConditionsClosed() {
        this.boundaryConditionsClosed = true;
    }

    public void setBoundaryConditionsOpen() {
        this.boundaryConditionsClosed = false;
    }

    public void setAcceleration(double d) {
        this.acceleration = d;
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.accelerationChanged(d);
        }
    }

    public void setVelocity(double d) {
        this.velocity = d;
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.velocityChanged(d);
        }
    }

    public void setGrabbed(boolean bl) {
        if (this.grabbed != bl) {
            this.grabbed = bl;
            if (!bl) {
                this.setVelocity(0.0);
                this.setAcceleration(0.0);
            }
        }
    }

    public double getPosition() {
        return this.x;
    }

    public void setPosition(double d) {
        if (this.x == d) {
            return;
        }
        if (this.boundaryConditionsClosed) {
            if (d <= this.minX) {
                d = this.minX;
                this.notifyCollision();
            } else if (d >= this.maxX) {
                d = this.maxX;
                this.notifyCollision();
            }
        }
        this.x = d;
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.positionChanged(d);
        }
    }

    public void reset() {
        this.setPosition(this.x0);
        this.setVelocity(0.0);
        this.setAcceleration(0.0);
    }

    public void stepInTime(double d) {
        if (this.grabbed) {
            return;
        }
        double d2 = this.velocity + this.acceleration * d;
        double d3 = this.x + this.velocity * d;
        if (this.boundaryConditionsClosed) {
            if (d3 > this.maxX || d3 < this.minX) {
                this.setVelocity(0.0);
                this.setAcceleration(0.0);
                if (d3 > this.maxX) {
                    this.setPosition(this.maxX);
                    this.notifyCollision();
                } else if (d3 < this.minX) {
                    this.setPosition(this.minX);
                    this.notifyCollision();
                }
            } else {
                d3 = Math.min(d3, this.maxX);
                d3 = Math.max(d3, this.minX);
                this.setVelocity(d2);
                this.setPosition(d3);
            }
        } else {
            this.setVelocity(d2);
            this.setPosition(d3);
        }
    }

    private void notifyCollision() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.collided(this);
        }
    }

    public boolean isMinimum() {
        return this.x == this.minX;
    }

    public boolean isMaximum() {
        return this.x == this.maxX;
    }

    public static class Adapter
    implements Listener {
        public void positionChanged(double d) {
        }

        public void velocityChanged(double d) {
        }

        public void accelerationChanged(double d) {
        }

        public void collided(Man man) {
        }
    }

    public static interface Listener {
        public void positionChanged(double var1);

        public void velocityChanged(double var1);

        public void accelerationChanged(double var1);

        public void collided(Man var1);
    }

    public static class Direction {
        String name;
        double value;
        public static final Direction LEFT = new Direction("Left", -1.0);
        public static final Direction RIGHT = new Direction("Right", 1.0);
        public static final Direction STILL = new Direction("Still", 0.0);

        private Direction(String string, double d) {
            this.name = string;
            this.value = d;
        }

        public double doubleValue() {
            return this.value;
        }
    }
}

