/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.model;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_movingman.model.ModelElement;
import edu.colorado.phet.common_movingman.model.clock.AbstractClock;
import edu.colorado.phet.common_movingman.view.components.VerticalLayoutPanel;
import edu.colorado.phet.common_movingman.view.util.SwingUtils;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.model.CenteredDifferenceDerivative;
import edu.colorado.phet.movingman.model.CollisionAudioEffects;
import edu.colorado.phet.movingman.model.DataSuite;
import edu.colorado.phet.movingman.model.Man;
import edu.colorado.phet.movingman.model.MovingManTimeModel;
import edu.colorado.phet.movingman.plots.TimePoint;
import edu.colorado.phet.movingman.plots.TimeSeries;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MovingManModel {
    private MovingManTimeModel timeModel;
    private int maxManPosition = 10;
    private Man man;
    private AbstractClock clock;
    private DataSuite positionDataSuite;
    private DataSuite velocityDataSuite;
    private DataSuite accelerationDataSuite;
    private MovingManModule module;
    private double minTime = 0.0;
    private double maxTime = 20.0;
    private TimeSeries directionSeries;
    private int constancyTestWindowSize = 10;
    private boolean useConstancyWindow = false;
    private boolean smoothingSmooth = true;
    private int smoothPositionSize = 8;
    private int smoothVelocitySize = 6;
    private int smoothAccelerationSize = 4;
    private JFrame controls;

    public MovingManModel(MovingManModule movingManModule, AbstractClock abstractClock) {
        this.timeModel = new MovingManTimeModel(movingManModule);
        this.module = movingManModule;
        this.clock = abstractClock;
        this.positionDataSuite = new DataSuite(this.getSmoothPositionSize());
        this.velocityDataSuite = new DataSuite(this.getSmoothVelocitySize());
        this.accelerationDataSuite = new DataSuite(this.getSmoothAccelerationSize());
        this.directionSeries = new TimeSeries();
        this.man = new Man(0.0, -this.maxManPosition, this.maxManPosition);
        this.man.addListener(new CollisionAudioEffects(movingManModule, this.man));
        this.controls = new ControlFrame();
    }

    public void showControls() {
        this.controls.setVisible(true);
    }

    public boolean isSmoothingSmooth() {
        return this.smoothingSmooth;
    }

    public void setSmoothingSharp() {
        this.setNumSmoothingPoints(2);
        this.smoothingSmooth = false;
    }

    public void setSmoothingSmooth() {
        this.positionDataSuite.setNumSmoothingPoints(this.getSmoothPositionSize());
        this.velocityDataSuite.setNumSmoothingPoints(this.getSmoothVelocitySize());
        this.accelerationDataSuite.setNumSmoothingPoints(this.getSmoothAccelerationSize());
        this.smoothingSmooth = true;
    }

    private int getSmoothAccelerationSize() {
        return this.smoothAccelerationSize;
    }

    private int getSmoothVelocitySize() {
        return this.smoothVelocitySize;
    }

    private int getSmoothPositionSize() {
        return this.smoothPositionSize;
    }

    public void setNumSmoothingPoints(int n) {
        this.positionDataSuite.setNumSmoothingPoints(n);
        this.velocityDataSuite.setNumSmoothingPoints(n);
        this.accelerationDataSuite.setNumSmoothingPoints(n);
    }

    public void reset() {
        this.getTimeModel().reset();
        this.man.reset();
        this.positionDataSuite.reset();
        this.velocityDataSuite.reset();
        this.accelerationDataSuite.reset();
        this.directionSeries.reset();
    }

    public void step(double d) {
        double d2 = this.timeModel.getRecordTimer().getTime();
        this.directionSeries.addPoint(this.getDirection().doubleValue(), d2);
        this.positionDataSuite.addPoint(this.man.getPosition(), d2);
        this.positionDataSuite.updateSmoothedSeries();
        boolean bl = this.isConstant(this.positionDataSuite.getRawData(), this.constancyTestWindowSize);
        TimePoint timePoint = new CenteredDifferenceDerivative().getLatestDerivative(this.positionDataSuite.getSmoothedDataSeries());
        if (timePoint != null) {
            if (bl && this.useConstancyWindow) {
                this.velocityDataSuite.addPoint(new TimePoint(0.0, timePoint.getTime()));
            } else {
                this.velocityDataSuite.addPoint(timePoint);
            }
        }
        this.velocityDataSuite.updateSmoothedSeries();
        TimePoint timePoint2 = new CenteredDifferenceDerivative().getLatestDerivative(this.velocityDataSuite.getSmoothedDataSeries());
        if (timePoint2 != null) {
            if (bl) {
                this.accelerationDataSuite.addPoint(new TimePoint(0.0, timePoint2.getTime()));
            } else {
                this.accelerationDataSuite.addPoint(timePoint2);
            }
        }
        this.accelerationDataSuite.updateSmoothedSeries();
    }

    private boolean isConstant(TimeSeries timeSeries, int n) {
        TimePoint timePoint = timeSeries.lastPointAt(0);
        double d = timePoint.getValue();
        for (int i = 1; i < n && i < timeSeries.numPoints(); ++i) {
            if (timeSeries.lastPointAt(i).getValue() == d) continue;
            return false;
        }
        return true;
    }

    private Man.Direction getDirection() {
        return this.module.getDirection();
    }

    public Man getMan() {
        return this.man;
    }

    public DataSuite getPositionDataSuite() {
        return this.positionDataSuite;
    }

    public DataSuite getVelocitySeries() {
        return this.velocityDataSuite;
    }

    public DataSuite getAccelerationDataSuite() {
        return this.accelerationDataSuite;
    }

    public double getMaxTime() {
        return this.maxTime;
    }

    public double getMinTime() {
        return this.minTime;
    }

    public double getMaxManPosition() {
        return this.maxManPosition;
    }

    public ModelElement getMainModelElement() {
        return this.timeModel.getMainModelElement();
    }

    public void fireReset() {
        this.timeModel.fireReset();
    }

    public void setRecordMode() {
        this.timeModel.setRecordMode();
    }

    public MovingManTimeModel getTimeModel() {
        return this.timeModel;
    }

    public void setReplayTime(double d) {
        TimePoint timePoint = this.positionDataSuite.getSmoothedDataSeries().getValueForTime(d);
        this.man.setPosition(timePoint.getValue());
        double d2 = this.directionSeries.getValueForTime(d).getValue();
        this.module.setReplayManDirection(d2);
    }

    public void setBoundaryConditionsClosed() {
        this.man.setBoundaryConditionsClosed();
    }

    public void setBoundaryConditionsOpen() {
        this.man.setBoundaryConditionsOpen();
    }

    static /* synthetic */ int access$002(MovingManModel movingManModel, int n) {
        movingManModel.smoothPositionSize = n;
        return movingManModel.smoothPositionSize;
    }

    static /* synthetic */ DataSuite access$200(MovingManModel movingManModel) {
        return movingManModel.positionDataSuite;
    }

    static /* synthetic */ int access$302(MovingManModel movingManModel, int n) {
        movingManModel.smoothVelocitySize = n;
        return movingManModel.smoothVelocitySize;
    }

    static /* synthetic */ DataSuite access$400(MovingManModel movingManModel) {
        return movingManModel.velocityDataSuite;
    }

    static /* synthetic */ int access$502(MovingManModel movingManModel, int n) {
        movingManModel.smoothAccelerationSize = n;
        return movingManModel.smoothAccelerationSize;
    }

    static /* synthetic */ DataSuite access$600(MovingManModel movingManModel) {
        return movingManModel.accelerationDataSuite;
    }

    static /* synthetic */ boolean access$802(MovingManModel movingManModel, boolean bl) {
        movingManModel.useConstancyWindow = bl;
        return movingManModel.useConstancyWindow;
    }

    class ControlFrame
    extends JFrame {
        private JPanel contentPanel;

        public ControlFrame() {
            super(SimStrings.get("options.model-controls"));
            this.contentPanel = new VerticalLayoutPanel();
            this.setContentPane(this.contentPanel);
            JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(MovingManModel.this.smoothPositionSize, 1, 20, 1));
            jSpinner.addChangeListener(new ChangeListener(this, jSpinner){
                private final /* synthetic */ JSpinner val$xs;
                private final /* synthetic */ ControlFrame this$1;
                {
                    this.this$1 = controlFrame;
                    this.val$xs = jSpinner;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    MovingManModel.access$002(ControlFrame.access$100(this.this$1), ((Number)this.val$xs.getValue()).intValue());
                    MovingManModel.access$200(ControlFrame.access$100(this.this$1)).setNumSmoothingPoints(MovingManModel.access$000(ControlFrame.access$100(this.this$1)));
                }
            });
            jSpinner.setBorder(BorderFactory.createTitledBorder(SimStrings.get("variables.position.abbreviation")));
            JSpinner jSpinner2 = new JSpinner(new SpinnerNumberModel(MovingManModel.this.smoothVelocitySize, 1, 20, 1));
            jSpinner2.setBorder(BorderFactory.createTitledBorder(SimStrings.get("variables.velocity.abbreviation")));
            jSpinner2.addChangeListener(new ChangeListener(this, jSpinner2){
                private final /* synthetic */ JSpinner val$vs;
                private final /* synthetic */ ControlFrame this$1;
                {
                    this.this$1 = controlFrame;
                    this.val$vs = jSpinner;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    MovingManModel.access$302(ControlFrame.access$100(this.this$1), ((Number)this.val$vs.getValue()).intValue());
                    MovingManModel.access$400(ControlFrame.access$100(this.this$1)).setNumSmoothingPoints(MovingManModel.access$300(ControlFrame.access$100(this.this$1)));
                }
            });
            JSpinner jSpinner3 = new JSpinner(new SpinnerNumberModel(MovingManModel.this.smoothAccelerationSize, 1, 20, 1));
            jSpinner3.addChangeListener(new ChangeListener(this, jSpinner3){
                private final /* synthetic */ JSpinner val$as;
                private final /* synthetic */ ControlFrame this$1;
                {
                    this.this$1 = controlFrame;
                    this.val$as = jSpinner;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    MovingManModel.access$502(ControlFrame.access$100(this.this$1), ((Number)this.val$as.getValue()).intValue());
                    MovingManModel.access$600(ControlFrame.access$100(this.this$1)).setNumSmoothingPoints(MovingManModel.access$500(ControlFrame.access$100(this.this$1)));
                }
            });
            jSpinner3.setBorder(BorderFactory.createTitledBorder(SimStrings.get("variables.acceleration.abbreviation")));
            JLabel jLabel = new JLabel(SimStrings.get("options.model-controls.explanation"));
            this.addComponent(jLabel);
            this.addComponent(jSpinner);
            this.addComponent(jSpinner2);
            this.addComponent(jSpinner3);
            JSpinner jSpinner4 = new JSpinner(new SpinnerNumberModel(MovingManModel.this.constancyTestWindowSize, 1, 20, 1));
            jSpinner4.setBorder(BorderFactory.createTitledBorder(SimStrings.get("options.constant-check-window")));
            JCheckBox jCheckBox = new JCheckBox(SimStrings.get("options.use-constant-window"), MovingManModel.this.useConstancyWindow);
            jCheckBox.addActionListener(new ActionListener(this, MovingManModel.this, jCheckBox){
                private final /* synthetic */ MovingManModel val$this$0;
                private final /* synthetic */ JCheckBox val$useConstantWindow;
                private final /* synthetic */ ControlFrame this$1;
                {
                    this.this$1 = controlFrame;
                    this.val$this$0 = movingManModel;
                    this.val$useConstantWindow = jCheckBox;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    MovingManModel.access$802(ControlFrame.access$100(this.this$1), this.val$useConstantWindow.isSelected());
                }
            });
            this.addComponent(jCheckBox);
            this.addComponent(jSpinner4);
            this.pack();
            SwingUtils.centerWindowOnScreen(this);
        }

        private void addComponent(JComponent jComponent) {
            this.contentPanel.add(jComponent);
        }

        static /* synthetic */ MovingManModel access$100(ControlFrame controlFrame) {
            return controlFrame.MovingManModel.this;
        }
    }
}

