/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.model;

import edu.colorado.phet.common_movingman.model.ModelElement;
import edu.colorado.phet.movingman.MovingManModule;
import edu.colorado.phet.movingman.model.MMTimer;
import edu.colorado.phet.movingman.model.Mode;
import edu.colorado.phet.movingman.model.PlaybackMode;
import edu.colorado.phet.movingman.model.RecordMode;
import edu.colorado.phet.movingman.model.TimeListener;
import java.util.ArrayList;

public class MovingManTimeModel {
    private ArrayList listeners = new ArrayList();
    private boolean paused = true;
    private Mode mode;
    private RecordMode recordMode;
    private PlaybackMode playbackMode;
    private ModelElement mainModelElement = new ModelElement(){

        public void stepInTime(double d) {
            if (!MovingManTimeModel.this.paused) {
                MovingManTimeModel.this.mode.stepInTime(d * TIME_SCALE);
            }
        }
    };
    public static double TIME_SCALE = 1.0;
    private boolean stopped = false;
    public static boolean dynamicTime;
    private MovingManModule module;

    public MovingManTimeModel(MovingManModule movingManModule) {
        this.recordMode = new RecordMode(movingManModule, this);
        this.playbackMode = new PlaybackMode(movingManModule, this);
        this.module = movingManModule;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public MMTimer getRecordTimer() {
        return this.recordMode.getTimer();
    }

    public MMTimer getPlaybackTimer() {
        return this.playbackMode.getTimer();
    }

    public RecordMode getRecordMode() {
        return this.recordMode;
    }

    public ModelElement getMainModelElement() {
        return this.mainModelElement;
    }

    public void fireReset() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TimeListener timeListener = (TimeListener)this.listeners.get(i);
            timeListener.reset();
        }
    }

    private void firePause() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TimeListener timeListener = (TimeListener)this.listeners.get(i);
            if (this.mode == this.recordMode) {
                timeListener.recordingPaused();
                continue;
            }
            timeListener.playbackPaused();
        }
    }

    public void firePlaybackFinished() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TimeListener timeListener = (TimeListener)this.listeners.get(i);
            timeListener.playbackFinished();
        }
    }

    public void fireFinishedRecording() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TimeListener timeListener = (TimeListener)this.listeners.get(i);
            timeListener.recordingFinished();
        }
    }

    public void addListener(TimeListener timeListener) {
        this.listeners.add(timeListener);
    }

    public void setPaused(boolean bl) {
        if (bl != this.paused) {
            this.paused = bl;
            if (bl) {
                this.firePause();
            } else if (this.isRecording()) {
                this.fireRecordStarted();
            } else if (this.isPlayback()) {
                this.firePlaybackStarted();
            }
        }
    }

    private void firePlaybackStarted() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TimeListener timeListener = (TimeListener)this.listeners.get(i);
            timeListener.playbackStarted();
        }
    }

    private boolean isPlayback() {
        return this.mode == this.playbackMode;
    }

    private void fireRecordStarted() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TimeListener timeListener = (TimeListener)this.listeners.get(i);
            timeListener.recordingStarted();
        }
    }

    public void reset() {
        this.setPaused(true);
        this.recordMode.reset();
        this.playbackMode.reset();
        this.fireReset();
    }

    public boolean isRecordMode() {
        return this.mode == this.recordMode;
    }

    public void setRecordMode() {
        this.setMode(this.recordMode);
    }

    public void setMode(Mode mode) {
        boolean bl;
        boolean bl2 = bl = mode == this.mode;
        if (!bl) {
            this.mode = mode;
            this.mode.initialize();
        }
    }

    private void fireRewind() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TimeListener timeListener = (TimeListener)this.listeners.get(i);
            timeListener.rewind();
        }
    }

    public void rewind() {
        this.playbackMode.rewind();
        this.fireRewind();
    }

    public void startPlaybackMode(double d) {
        this.stopped = false;
        this.playbackMode.setPlaybackSpeed(d);
        this.setMode(this.playbackMode);
        this.setPaused(false);
    }

    public boolean isRecording() {
        return this.mode == this.recordMode && !this.isPaused();
    }

    public void setDynamicTime(boolean bl) {
        dynamicTime = bl;
        TIME_SCALE = bl ? 1.0 : 0.02;
    }

    public boolean isAtEndOfTime() {
        return this.getRecordTimer().getTime() == this.module.getMovingManModel().getMaxTime();
    }
}

